/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.locale.Resource;

public class TaskMemberCellEditor
extends JComboBox {
    private static final long serialVersionUID = -2162048356937129713L;
    Project project;

    public TaskMemberCellEditor(Project project) {
        this.project = project;
        this.setModel(project.getTaskMemberComboBoxModel());
        this.setRenderer(new TaskMemberListCellRenderer());
        this.setUI(new StyledComboBoxUI());
    }

    class StyledComboBoxUI
    extends BasicComboBoxUI {
        StyledComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){
                private static final long serialVersionUID = 9216393246368274687L;

                @Override
                protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
                    return super.computePopupBounds(px, py, Math.max(this.comboBox.getPreferredSize().width, pw), ph);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }

    class TaskMemberListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8961880883385311841L;

        TaskMemberListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String stringValue = value == null ? Resource.get("listResourceNone") : ((Member)value).getName();
            return super.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
        }
    }
}

