/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskListScrollPane;
import jp.sourceforge.freegantt.swing.TaskListTable;

public class TaskListRootPane
extends JPanel {
    private static final long serialVersionUID = 1618049203954194983L;
    Application app;
    TaskListScrollPane taskListScrollPane;
    TaskListTable taskListPane;

    public TaskListRootPane(Application app) {
        this.app = app;
        this.setLayout(null);
        this.taskListPane = new TaskListTable(app);
        this.taskListPane.setBounds(0, 0, 300, 400);
        this.taskListPane.setFillsViewportHeight(true);
        this.taskListPane.setPreferredScrollableViewportSize(new Dimension(1000, 1000));
        JTableHeader header = this.taskListPane.getTableHeader();
        Dimension dim = header.getPreferredSize();
        header.setPreferredSize(new Dimension(1, 32));
        this.taskListScrollPane = new TaskListScrollPane(this.taskListPane);
        this.taskListScrollPane.setBounds(0, 0, 300, 200);
        this.taskListScrollPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        Border border = BorderFactory.createEmptyBorder();
        this.taskListScrollPane.setBorder(border);
        this.add(this.taskListScrollPane);
        this.taskListScrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport dataViewport = TaskListRootPane.this.app.getDataViewport();
                Point newViewPosition = TaskListRootPane.this.taskListScrollPane.getViewport().getViewPosition();
                Point currentViewPosition = dataViewport.getViewPosition();
                dataViewport.setViewPosition(new Point(currentViewPosition.x, newViewPosition.y));
            }
        });
    }

    public TaskListTable getTaskListPane() {
        return this.taskListPane;
    }

    public TaskListScrollPane getTaskListScrollPane() {
        return this.taskListScrollPane;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.taskListScrollPane.setSize(this.getSize());
    }
}

