/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.PreviewDialog;

public class ApplicationMenu
extends JMenuBar {
    private static final long serialVersionUID = -8682706642684252609L;
    Application application;

    public ApplicationMenu(final Application application) {
        this.application = application;
        JMenu menu = new JMenu(Resource.get("menuFile"));
        JMenuItem item = new JMenuItem(Resource.get("menuFileNew"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.newFile();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileOpen"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.loadData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSave"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.saveData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSaveAs"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.saveAsData();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Resource.get("menuFilePreview"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog dialog = new PreviewDialog(application);
                dialog.setVisible(true);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFilePage"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.configurePage();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFilePrint"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.print();
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuView"));
        item = new JMenuItem(Resource.get("menuViewInfo"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.openConfig(0);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuViewResource"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.openConfig(1);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuViewHoliday"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.openConfig(2);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Resource.get("menuViewPage"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.getTaskLineDataPane().setPrintRangeMode(!application.getTaskLineDataPane().isPrintRangeMode());
                application.getTaskLineDataPane().repaint();
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu(Resource.get("menuLang"));
        item = new JMenuItem(Resource.get("menuLangEn"));
        item.setEnabled(!application.getLocale().getLanguage().equals(Locale.ENGLISH.getLanguage()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.updateLocale(Locale.ENGLISH);
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuLangJp"));
        item.setEnabled(!application.getLocale().getLanguage().equals(Locale.JAPANESE.getLanguage()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.updateLocale(Locale.JAPANESE);
            }
        });
        menu.add(item);
        this.add(menu);
    }
}

