/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.util;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalendarUtil {
    private static Pattern DATE_PATTERN = Pattern.compile("([1-2][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})");
    private static Pattern DATE_PATTERN_NUMERIC = Pattern.compile("([1-2][0-9]{3})([0-9]{2})([0-9]{2})");

    public static Calendar toDateCalendar(Calendar cal) {
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar get(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        return CalendarUtil.toDateCalendar(cal);
    }

    public static Calendar parseDate(String str) {
        Matcher matcher = DATE_PATTERN.matcher(str);
        if (matcher.find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2).replaceFirst("^0", "")) - 1;
            int day = Integer.parseInt(matcher.group(3).replaceFirst("^0", ""));
            return CalendarUtil.get(year, month, day);
        }
        matcher = DATE_PATTERN_NUMERIC.matcher(str);
        if (matcher.find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2).replaceFirst("^0", "")) - 1;
            int day = Integer.parseInt(matcher.group(3).replaceFirst("^0", ""));
            return CalendarUtil.get(year, month, day);
        }
        return null;
    }

    public static int subDate(Calendar lhs, Calendar rhs) {
        if (lhs == null || rhs == null) {
            return 0;
        }
        return (int)((lhs.getTimeInMillis() - rhs.getTimeInMillis()) / 86400000L);
    }
}

