/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class TaskListTableModel
implements TableModel {
    public static int ADDITION_ROOM_COUNT = 20;
    public static String[] columnNames = new String[]{"", "\u30bf\u30b9\u30af\u540d", "\u30ea\u30bd\u30fc\u30b9", "\u5de5\u671f", "\u9054\u6210", "\u958b\u59cb\u65e5"};
    public static String[] COLOMN_KEYS = new String[]{"", "name", "resouce", "period", "completion", "startDate"};
    List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();
    Project project;

    public TaskListTableModel(Project project) {
        this.project = project;
    }

    @Override
    public int getRowCount() {
        int size = ADDITION_ROOM_COUNT;
        for (Task task : this.project.getTasks()) {
            size = Math.max(task.getIndex() + ADDITION_ROOM_COUNT, size);
        }
        return size;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= columnNames.length) {
            return null;
        }
        return columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Member.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex + 1;
        }
        Task task = this.project.findTask(rowIndex);
        if (task == null) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                return task.getName();
            }
            case 2: {
                return task.getMember();
            }
            case 3: {
                return task.getPeriod() == null ? null : String.valueOf(task.getPeriod());
            }
            case 4: {
                if (task.getStartDate() == null) {
                    return null;
                }
                if (task.isMilestone()) {
                    return null;
                }
                return task.getCompletion();
            }
            case 5: {
                SimpleDateFormat dateFormat = new SimpleDateFormat(Resource.get("dateFormat"));
                return task.getStartDate() == null ? null : dateFormat.format(task.getStartDate().getTime());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Task task = this.project.findTask(rowIndex);
        if (task == null) {
            task = new Task();
            task.setIndex(rowIndex);
            this.project.getTasks().add(task);
        }
        switch (columnIndex) {
            case 1: {
                task.setName((String)aValue);
                break;
            }
            case 2: {
                task.setMember((Member)aValue);
                break;
            }
            case 3: {
                try {
                    task.setPeriod(aValue == null || ((String)aValue).isEmpty() ? null : Integer.valueOf(Integer.parseInt((String)aValue)));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 4: {
                if (task.getStartDate() == null || task.isMilestone()) break;
                try {
                    task.setCompletion(aValue == null || ((String)aValue).isEmpty() ? 0 : Integer.parseInt((String)aValue));
                }
                catch (NumberFormatException ex) {
                    task.setCompletion(0);
                }
                break;
            }
            case 5: {
                if (aValue == null || ((String)aValue).isEmpty()) {
                    task.setStartDate(null);
                    break;
                }
                Calendar startDate = CalendarUtil.parseDate((String)aValue);
                if (startDate == null) break;
                task.setStartDate(startDate);
                if (task.getPeriod() != null) break;
                task.setPeriod(0);
            }
        }
        this.project.update();
        for (TableModelListener listener : this.tableModelListeners) {
            TableModelEvent e = new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0);
            listener.tableChanged(e);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void fireTableChanged() {
        for (TableModelListener listener : this.tableModelListeners) {
            TableModelEvent e = new TableModelEvent(this, 0, 0, 0, 0);
            listener.tableChanged(e);
        }
    }
}

