/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskLineDataPane;
import jp.sourceforge.freegantt.swing.TaskListTableModel;
import jp.sourceforge.freegantt.swing.TaskMemberCellEditor;
import jp.sourceforge.freegantt.swing.TaskMemberCellRenderer;
import jp.sourceforge.freegantt.swing.TaskNameCellRenderer;

public class TaskListTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = -2059641956588584594L;
    Application app;
    Project project;
    TaskListTableModel tableModel;
    TaskNameCellRenderer taskNameCellRenderer;
    Color borderColor = new Color(192, 192, 192);

    public TaskListTableModel getTaskListTableModel() {
        return this.tableModel;
    }

    public TaskListTable(Application app) {
        this.app = app;
        this.project = app.getProject();
        this.setGridColor(this.borderColor);
        this.setAutoResizeMode(4);
        this.addMouseListener(this);
        this.tableModel = this.project.getTaskTableModel();
        this.setModel(this.tableModel);
        int i = 0;
        while (i < TaskListTableModel.COLOMN_KEYS.length) {
            this.getColumnModel().getColumn(i).setIdentifier(TaskListTableModel.COLOMN_KEYS[i]);
            ++i;
        }
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(2).setCellRenderer(new TaskMemberCellRenderer());
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(new TaskMemberCellEditor(this.project)));
        this.taskNameCellRenderer = new TaskNameCellRenderer(this.project);
        columnModel.getColumn(0).setCellRenderer(this.getTableHeader().getDefaultRenderer());
        columnModel.getColumn(0).setPreferredWidth(30);
        columnModel.getColumn(0).setMaxWidth(30);
        columnModel.getColumn(0).setMinWidth(30);
        columnModel.getColumn(1).setPreferredWidth(120);
        columnModel.getColumn(1).setMinWidth(0);
        columnModel.getColumn(1).setCellRenderer(this.taskNameCellRenderer);
        columnModel.getColumn(2).setPreferredWidth(60);
        columnModel.getColumn(3).setPreferredWidth(30);
        columnModel.getColumn(4).setPreferredWidth(30);
        columnModel.getColumn(5).setPreferredWidth(80);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.app == null) {
            return;
        }
        TaskLineDataPane taskLineDataPane = this.app.getTaskLineDataPane();
        if (taskLineDataPane != null) {
            taskLineDataPane.setSize(new Dimension(taskLineDataPane.getWidth(), this.getTaskListTableModel().getRowCount() * 16));
            taskLineDataPane.setPreferredSize(new Dimension(taskLineDataPane.getWidth(), this.getTaskListTableModel().getRowCount() * 16));
            System.out.println("DataPane setPreferredSize: " + taskLineDataPane.getWidth() + "," + this.getTaskListTableModel().getRowCount() * 16);
        }
        if (this.app.getTaskListScrollPane() != null) {
            this.app.getTaskListScrollPane().getViewport().validate();
        }
        if (this.app.getTaskLineDataPane() != null) {
            this.app.getTaskLineDataPane().repaint();
        }
        if (this.app.getTaskListPane() != null) {
            this.app.getTaskListPane().repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
        }
    }

    private void triggerPopup(MouseEvent e) {
        Task task;
        int[] selectedRows;
        int row = this.rowAtPoint(e.getPoint());
        if (row < 0) {
            return;
        }
        boolean found = false;
        int[] nArray = selectedRows = this.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            if (s == row) {
                found = true;
            }
            ++n2;
        }
        if (!found) {
            this.setRowSelectionInterval(row, row);
            this.repaint();
        }
        boolean isAvailableLevelUp = (task = this.project.findTask(row)) != null;
        boolean isAvailableLevelDown = task != null && task.getLevel() > 0;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("\u30bf\u30b9\u30af\u3092\u524a\u9664");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows;
                int deleted = 0;
                int[] nArray = selectedRows = TaskListTable.this.getSelectedRows();
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    TaskListTable.this.project.removeRow(s - deleted);
                    ++deleted;
                    ++n2;
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("\u30bf\u30b9\u30af\u3092\u633f\u5165");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows;
                int inserted = 0;
                int chained = 0;
                int preSelected = -1;
                int[] nArray = selectedRows = TaskListTable.this.getSelectedRows();
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    chained = preSelected + 1 == s ? ++chained : 0;
                    TaskListTable.this.project.insertRow(s + inserted - chained);
                    ++inserted;
                    preSelected = s;
                    ++n2;
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("\u30ec\u30d9\u30eb\u3092\u4e0a\u3052\u308b");
        item.setEnabled(isAvailableLevelUp);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                task.setLevel(task.getLevel() + 1);
                TaskListTable.this.project.update();
                TaskListTable.this.tableModel.fireTableChanged();
            }
        });
        menu.add(item);
        item = new JMenuItem("\u30ec\u30d9\u30eb\u3092\u4e0b\u3052\u308b");
        item.setEnabled(isAvailableLevelDown);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                task.setLevel(task.getLevel() - 1);
                TaskListTable.this.project.update();
                TaskListTable.this.tableModel.fireTableChanged();
            }
        });
        menu.add(item);
        menu.show(this, e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void doLayout() {
        JTableHeader header = this.getTableHeader();
        TableColumn resizingColumn = header.getResizingColumn();
        if (resizingColumn != null) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        TableColumnModel model = this.getColumnModel();
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn column = model.getColumn(i);
            column.setWidth(column.getPreferredWidth());
            ++i;
        }
    }
}

