/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskLinePane;
import jp.sourceforge.freegantt.util.CalendarUtil;
import jp.sourceforge.freegantt.util.StringUtil;

public class TaskLineHeaderPane
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 4416176242747877014L;
    Application app;
    TaskLinePane taskLinePane;
    Color lineColor = new Color(192, 192, 192);
    Color bgColor = Color.white;
    Color fontColor = Color.black;

    public TaskLineHeaderPane(Application app, TaskLinePane taskLinePane) {
        this.app = app;
        this.taskLinePane = taskLinePane;
        this.setBackground(this.bgColor);
        this.addMouseListener(this);
    }

    private int getCellHeight() {
        return this.taskLinePane.getCellHeight();
    }

    private int getCellWidth() {
        return this.taskLinePane.getCellWidth();
    }

    public void updateWidth() {
        Calendar fromDate = this.app.getProject().getChartFromDate();
        Calendar toDate = this.app.getProject().getChartToDate();
        this.setSize(CalendarUtil.subDate(toDate, fromDate) * this.getCellWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.lineColor);
        g.drawLine(0, this.getCellHeight() - 1, this.getWidth(), this.getCellHeight() - 1);
        g.drawLine(0, this.getCellHeight() * 2 - 1, this.getWidth(), this.getCellHeight() * 2 - 1);
        Calendar now = (Calendar)this.app.getProject().getChartFromDate().clone();
        Calendar to = this.app.getProject().getChartToDate();
        int offset = 0;
        while (now.getTimeInMillis() < to.getTimeInMillis()) {
            g.setColor(this.fontColor);
            if (now.get(5) == 1) {
                String text = String.valueOf(String.valueOf(now.get(1))) + "\u5e74" + String.valueOf(now.get(2) + 1) + "\u6708";
                StringUtil.drawStringLeft(g, text, offset, 0, this.getCellWidth(), this.getCellHeight());
            }
            StringUtil.drawScaledDate(g, String.valueOf(now.get(5)), offset, this.getCellHeight(), this.getCellWidth(), this.getCellHeight(), 0.7);
            now.add(5, 1);
            offset += this.getCellWidth();
            g.setColor(this.lineColor);
            if (now.get(5) == 1) {
                g.drawLine(offset - 1, 0, offset - 1, this.getHeight() - 1);
                continue;
            }
            g.drawLine(offset - 1, this.getCellHeight() - 1, offset - 1, this.getCellHeight() * 2 - 1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && e.getY() >= this.getCellHeight()) {
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && e.getY() >= this.getCellHeight()) {
            this.triggerPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private Calendar getCalendarAtPoint(Point p) {
        long offsetDate = p.x / this.getCellWidth();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.app.getProject().getChartFromDate().getTimeInMillis() + offsetDate * 86400000L);
        return calendar;
    }

    private void triggerPopup(MouseEvent e) {
        final Calendar calendar = this.getCalendarAtPoint(e.getPoint());
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("\u500b\u5225\u4f11\u65e5\u306b\u8ffd\u52a0\u3059\u308b");
        item.setEnabled(!this.app.getProject().isHoliday(calendar));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskLineHeaderPane.this.app.getProject().getAdditionalHolidays().add(calendar);
                TaskLineHeaderPane.this.app.getProject().update();
                TaskLineHeaderPane.this.app.getProject().getHolidayTableModel().fireTableChanged();
                TaskLineHeaderPane.this.app.getProject().getTaskTableModel().fireTableChanged();
            }
        });
        menu.add(item);
        item = new JMenuItem("\u500b\u5225\u4f11\u65e5\u304b\u3089\u524a\u9664\u3059\u308b");
        item.setEnabled(this.app.getProject().isAdditionalHoliday(calendar));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskLineHeaderPane.this.app.getProject().getAdditionalHolidays().remove(calendar);
                TaskLineHeaderPane.this.app.getProject().update();
                TaskLineHeaderPane.this.app.getProject().getHolidayTableModel().fireTableChanged();
                TaskLineHeaderPane.this.app.getProject().getTaskTableModel().fireTableChanged();
            }
        });
        menu.add(item);
        menu.show(this, e.getX(), e.getY());
    }
}

