/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.CursorState;
import jp.sourceforge.freegantt.swing.TaskLinePane;
import jp.sourceforge.freegantt.util.CalendarUtil;
import jp.sourceforge.freegantt.util.Pair;
import jp.sourceforge.freegantt.util.StringUtil;

public class TaskLineDataPane
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 4173201298740221449L;
    Application app;
    Project project;
    TaskLinePane taskLinePane;
    CursorState cursorState;
    PrintRange printRange;
    TaskUI taskUI;
    RestrictionUI restrictionUI;
    boolean restrictionMode = false;
    static final int OPERATION_NONE = 0;
    static final int OPERATION_CREATE = 1;
    static final int OPERATION_SLIDE = 2;
    static final int OPERATION_PERIOD = 3;
    static final int OPERATION_COMPLETION = 4;
    static final int OPERATION_RESTRICTION = 5;
    static final int OPERATION_PRINT_RANGE_X = 6;
    static final int OPERATION_PRINT_RANGE_Y = 7;
    static final int OPERATION_PRINT_RANGE = 8;
    int dragOperation = 0;
    Point dragStartPoint;
    Task targetTask;
    Color weekLineColor = new Color(208, 208, 208);
    Color bgColor = Color.white;
    Color holidayBgColor = new Color(240, 240, 240);
    Color borderColor = new Color(117, 81, 224);
    Color fillColor = new Color(218, 206, 252);
    Color completionColor = this.borderColor;
    Color groupColor = new Color(48, 48, 48);
    Color fontColor = new Color(48, 48, 48);
    Color activeColor = new Color(224, 48, 48);
    Color milestoneColor;
    Color restrictionColor = this.milestoneColor = this.groupColor;

    public PrintRange getPrintRange() {
        return this.printRange;
    }

    public boolean isPrintRangeMode() {
        return this.printRange.printRangeMode;
    }

    public void setPrintRangeMode(boolean printRangeMode) {
        this.printRange.printRangeMode = printRangeMode;
    }

    public int getCellWidth() {
        return this.taskLinePane.getCellWidth();
    }

    public int getCellHeight() {
        return this.taskLinePane.getCellHeight();
    }

    public TaskLineDataPane(Application app, Project project, TaskLinePane taskLinePane) {
        this.app = app;
        this.project = project;
        this.taskLinePane = taskLinePane;
        this.cursorState = new CursorState(this);
        this.printRange = new PrintRange();
        this.taskUI = new TaskUI();
        this.restrictionUI = new RestrictionUI();
        this.setBackground(this.bgColor);
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(1, project.getTaskTableModel().getRowCount() * this.getCellHeight()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void updateWidth() {
        Calendar fromDate = this.app.getProject().getChartFromDate();
        Calendar toDate = this.app.getProject().getChartToDate();
        this.setSize(CalendarUtil.subDate(toDate, fromDate) * this.getCellWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawBackground(g);
        this.drawTasks(g);
        this.restrictionUI.drawRestrictions(g);
        this.printRange.drawPrintRange(g);
    }

    private void drawBackground(Graphics g) {
        int drawableHeight = this.project.getTaskTableModel().getRowCount() * this.getCellHeight();
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Calendar now = (Calendar)this.project.getChartFromDate().clone();
        Calendar to = this.project.getChartToDate();
        int offset = 0;
        while (now.getTimeInMillis() < to.getTimeInMillis()) {
            if (this.project.isHoliday(now)) {
                g.setColor(this.holidayBgColor);
                g.fillRect(offset, 0, this.getCellWidth(), drawableHeight - 1);
            }
            now.add(5, 1);
            offset += this.getCellWidth();
            if (now.get(7) != 2) continue;
            g.setColor(this.weekLineColor);
            g.drawLine(offset - 1, 0, offset - 1, drawableHeight - 1);
        }
        g.setColor(this.weekLineColor);
        g.drawLine(0, drawableHeight - 1, this.getWidth(), drawableHeight - 1);
    }

    private void drawTasks(Graphics g) {
        for (Task task : this.project.getTasks()) {
            this.drawTask(g, task);
        }
    }

    private void drawTask(Graphics g, Task task) {
        if (task == null) {
            return;
        }
        Rectangle rect = this.getTaskRect(task);
        if (rect == null) {
            return;
        }
        if (task.isMilestone()) {
            this.drawMilestone(g, task, rect);
        } else if (task.isParent()) {
            this.drawParentTask(g, task, rect);
        } else {
            this.drawBasicTask(g, task, rect);
        }
    }

    private void drawMilestone(Graphics g, Task task, Rectangle rect) {
        g.setColor(this.milestoneColor);
        int half = rect.height / 2;
        Polygon polygon = new Polygon(new int[]{rect.x, rect.x - half, rect.x, rect.x + half}, new int[]{rect.y, rect.y + half, rect.y + rect.height, rect.y + half}, 4);
        g.fillPolygon(polygon);
    }

    private void drawParentTask(Graphics g, Task task, Rectangle rect) {
        g.setColor(this.groupColor);
        int half = rect.height * 2 / 3;
        Polygon polygon = new Polygon(new int[]{rect.x, rect.x, rect.x + half, rect.x + rect.width - half, rect.x + rect.width, rect.x + rect.width, rect.x + rect.width}, new int[]{rect.y, rect.y + rect.height, rect.y + rect.height - half, rect.y + rect.height - half, rect.y + rect.height, rect.y}, 6);
        g.fillPolygon(polygon);
    }

    private void drawBasicTask(Graphics g, Task task, Rectangle rect) {
        g.setColor(this.fillColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        if (task.getCompletion() > 0) {
            g.setColor(this.borderColor);
            g.fillRect(rect.x, rect.y, rect.width * task.getCompletion() / 100, rect.height);
        }
        if (task.getCompletion() > 0) {
            MessageFormat format = new MessageFormat("{0}%");
            g.setColor(this.fontColor);
            g.drawString(format.format(new Object[]{task.getCompletion()}), rect.x + rect.width + this.getCellWidth(), rect.y + rect.height);
        }
        g.setColor(this.borderColor);
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    private Rectangle getTaskRect(Task task) {
        if (task == null || !task.isDrawable()) {
            return null;
        }
        int dateOffset = (int)((task.getStartDate().getTimeInMillis() - this.project.getChartFromDate().getTimeInMillis()) / 86400000L);
        int period = task.getRealPeriod();
        int offsetY = task.getIndex() * this.getCellHeight();
        return new Rectangle(dateOffset * this.getCellWidth(), offsetY + this.getCellHeight() / 4, this.getCellWidth() * period, this.getCellHeight() / 2);
    }

    private Rectangle getTaskHitRect(Task task) {
        if (task == null || task.getStartDate() == null) {
            return null;
        }
        int dateOffset = (int)((task.getStartDate().getTimeInMillis() - this.project.getChartFromDate().getTimeInMillis()) / 86400000L);
        int period = task.getRealPeriod();
        int offsetY = task.getIndex() * this.getCellHeight();
        return new Rectangle(dateOffset * this.getCellWidth() - this.getCellWidth() / 3, offsetY + this.getCellHeight() / 4, this.getCellWidth() * period + this.getCellWidth() / 3 * 2, this.getCellHeight() / 2);
    }

    private void repaintProject() {
        if (this.app.getTaskListPane() != null) {
            this.app.getTaskListPane().repaint();
        }
        if (this.app.getTaskLineHeaderPane() != null) {
            this.app.getTaskLineHeaderPane().repaint();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragOperation == 0) {
            return;
        }
        if (this.printRange.mouseDragged(e)) {
            return;
        }
        if (this.taskUI.mouseDragged(e)) {
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.restrictionMode) {
            if (this.printRange.mouseMoved(e)) {
                return;
            }
            if (this.taskUI.mouseMoved(e)) {
                return;
            }
            this.cursorState.setDefaultCursor();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
            return;
        }
        this.targetTask = null;
        this.dragOperation = 0;
        this.dragStartPoint = e.getPoint();
        int index = this.getIndexAtPoint(e.getPoint());
        if (index >= this.project.getTaskTableModel().getRowCount()) {
            return;
        }
        if (this.printRange.mousePressed(e)) {
            return;
        }
        if (this.restrictionUI.mousePressed(e)) {
            return;
        }
        if (this.taskUI.mousePressed(e)) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(e);
        }
        if (this.restrictionUI.mouseReleased(e)) {
            return;
        }
    }

    private void triggerPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("\u30bf\u30b9\u30af\u3092\u524a\u9664");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private Calendar getCalendarAtPoint(Point p) {
        int offsetDate = p.x / this.getCellWidth();
        Calendar calendar = (Calendar)this.project.getChartFromDate().clone();
        calendar.add(5, offsetDate);
        return calendar;
    }

    private Calendar getEarlyBusinessDayAtPoint(Point p) {
        Calendar calendar = this.getCalendarAtPoint(p);
        int i = 0;
        while (i < 365) {
            if (!this.app.getProject().isHoliday(calendar)) break;
            calendar.add(5, -1);
            ++i;
        }
        return calendar;
    }

    private Calendar getLateBusinessDayAtPoint(Point p) {
        Calendar calendar = this.getCalendarAtPoint(p);
        int i = 0;
        while (i < 365) {
            if (!this.app.getProject().isHoliday(calendar)) break;
            calendar.add(5, 1);
            ++i;
        }
        return calendar;
    }

    private int getBusinessDayCount(Calendar from, Calendar to) {
        Calendar calendar = (Calendar)from.clone();
        int businessDayCount = 0;
        while (calendar.before(to)) {
            if (!this.app.getProject().isHoliday(calendar)) {
                ++businessDayCount;
            }
            calendar.add(5, 1);
        }
        return businessDayCount;
    }

    protected Task getTaskAtPoint(Point p) {
        if (p == null) {
            return null;
        }
        int index = this.getIndexAtPoint(p);
        Task task = this.project.findTask(index);
        if (task == null) {
            return null;
        }
        Rectangle rect = this.getTaskRect(task);
        if (rect == null) {
            return null;
        }
        return rect.contains(p) ? task : null;
    }

    private int getIndexAtPoint(Point point) {
        return point.y / this.getCellHeight();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.cursorState.setCursor(0x7FFFFFFE);
            this.restrictionMode = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.cursorState.setDefaultCursor();
            this.restrictionMode = false;
        }
    }

    public class PrintRange {
        Color printRangeFirstColor = new Color(240, 80, 80);
        Color printRangeColor = new Color(240, 160, 160);
        boolean printRangeMode = true;

        public void drawPrintRange(Graphics g) {
            if (!this.printRangeMode) {
                return;
            }
            List<Rectangle> ranges = this.getPrintRanges();
            int page = ranges.size();
            Collections.reverse(ranges);
            for (Rectangle r : ranges) {
                g.setColor(page == 1 ? this.printRangeFirstColor : this.printRangeColor);
                g.drawRect(r.x, r.y, r.width, r.height);
                g.drawRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
                g.drawRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
                Font oldFont = g.getFont();
                Font newFont = new Font(oldFont.getFontName(), 1, 32);
                g.setFont(newFont);
                String str = "\u30da\u30fc\u30b8" + page;
                Shape oldClip = g.getClip();
                g.clipRect(r.x, r.y, r.width, r.height);
                StringUtil.drawStringCenter(g, str, r.x, r.y, r.width, r.height);
                g.setClip(oldClip);
                g.setFont(oldFont);
                --page;
            }
        }

        public boolean mousePressed(MouseEvent e) {
            int printRangeOperation = this.getOperation(e);
            if (printRangeOperation == 0) {
                return false;
            }
            TaskLineDataPane.this.dragOperation = printRangeOperation;
            return true;
        }

        public boolean mouseMoved(MouseEvent e) {
            int operation = this.getOperation(e);
            switch (operation) {
                case 8: {
                    TaskLineDataPane.this.cursorState.setCursor(5);
                    return true;
                }
                case 6: {
                    TaskLineDataPane.this.cursorState.setCursor(11);
                    return true;
                }
                case 7: {
                    TaskLineDataPane.this.cursorState.setCursor(9);
                    return true;
                }
            }
            return false;
        }

        public boolean mouseDragged(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation == 6) {
                Rectangle rect = this.getFirstPrintRange();
                if (rect == null) {
                    return false;
                }
                TaskLineDataPane.this.project.getPrintCellSize().width = Math.max(10, (e.getX() - rect.x) / TaskLineDataPane.this.getCellWidth());
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 7) {
                Rectangle rect = this.getFirstPrintRange();
                if (rect == null) {
                    return false;
                }
                TaskLineDataPane.this.project.getPrintCellSize().height = Math.max(10, (e.getY() - rect.y) / TaskLineDataPane.this.getCellHeight());
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 8) {
                Rectangle rect = this.getFirstPrintRange();
                if (rect == null) {
                    return false;
                }
                TaskLineDataPane.this.project.getPrintCellSize().width = Math.max(10, (e.getX() - rect.x) / TaskLineDataPane.this.getCellWidth());
                TaskLineDataPane.this.project.getPrintCellSize().height = Math.max(10, (e.getY() - rect.y) / TaskLineDataPane.this.getCellHeight());
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            return false;
        }

        public int getOperation(MouseEvent e) {
            if (!this.printRangeMode) {
                return 0;
            }
            Rectangle rect = this.getFirstPrintRange();
            if (rect != null && e.getX() >= rect.x + rect.width - TaskLineDataPane.this.getCellWidth() / 2 && e.getX() < rect.x + rect.width && e.getY() >= rect.y + rect.height - TaskLineDataPane.this.getCellHeight() / 2 && e.getY() < rect.y + rect.height) {
                return 8;
            }
            if (rect != null && e.getX() >= rect.x + rect.width - TaskLineDataPane.this.getCellWidth() / 2 && e.getX() < rect.x + rect.width && e.getY() >= rect.y && e.getY() < rect.y + rect.height - TaskLineDataPane.this.getCellHeight() / 2) {
                return 6;
            }
            if (rect != null && e.getX() >= rect.x && e.getX() < rect.x + rect.width - TaskLineDataPane.this.getCellWidth() / 2 && e.getY() >= rect.y + rect.height - TaskLineDataPane.this.getCellHeight() / 2 && e.getY() < rect.y + rect.height) {
                return 7;
            }
            return 0;
        }

        public Rectangle getFirstPrintRange() {
            Calendar dataRangeFirstDate = TaskLineDataPane.this.project.getFirstDate();
            int dataRangePeriod = TaskLineDataPane.this.project.getWholePeriod();
            int maxIndex = TaskLineDataPane.this.project.getMaxIndex();
            if (dataRangeFirstDate == null) {
                return null;
            }
            Calendar printRangeFirstDate = dataRangeFirstDate;
            printRangeFirstDate.add(5, -1);
            int printRangePeriod = dataRangePeriod + 2;
            int offsetX = CalendarUtil.subDate(printRangeFirstDate, TaskLineDataPane.this.project.getChartFromDate()) * TaskLineDataPane.this.getCellWidth();
            Dimension printCellSize = TaskLineDataPane.this.project.getPrintCellSize();
            return new Rectangle(offsetX, 0, printCellSize.width * TaskLineDataPane.this.getCellWidth(), printCellSize.height * TaskLineDataPane.this.getCellHeight());
        }

        public List<Rectangle> getPrintRanges() {
            ArrayList<Rectangle> result = new ArrayList<Rectangle>();
            Calendar dataRangeFirstDate = TaskLineDataPane.this.project.getFirstDate();
            int dataRangePeriod = TaskLineDataPane.this.project.getWholePeriod();
            int maxIndex = TaskLineDataPane.this.project.getMaxIndex();
            if (dataRangeFirstDate == null) {
                return result;
            }
            Calendar printRangeFirstDate = dataRangeFirstDate;
            printRangeFirstDate.add(5, -1);
            int printRangePeriod = dataRangePeriod + 2;
            int page = 1;
            int offsetX = CalendarUtil.subDate(printRangeFirstDate, TaskLineDataPane.this.project.getChartFromDate()) * TaskLineDataPane.this.getCellWidth();
            Dimension printCellSize = TaskLineDataPane.this.project.getPrintCellSize();
            int cursorY = 0;
            while (cursorY <= maxIndex) {
                int cursorX = 0;
                while (cursorX < printRangePeriod) {
                    Rectangle r = new Rectangle(offsetX + cursorX * TaskLineDataPane.this.getCellWidth(), cursorY * TaskLineDataPane.this.getCellHeight(), printCellSize.width * TaskLineDataPane.this.getCellWidth(), printCellSize.height * TaskLineDataPane.this.getCellHeight());
                    result.add(r);
                    ++page;
                    cursorX += printCellSize.width;
                }
                cursorY += printCellSize.height;
            }
            return result;
        }
    }

    public class RestrictionUI {
        public boolean mousePressed(MouseEvent e) {
            if (!TaskLineDataPane.this.restrictionMode) {
                return false;
            }
            Task task = TaskLineDataPane.this.getTaskAtPoint(e.getPoint());
            if (task == null) {
                return false;
            }
            TaskLineDataPane.this.targetTask = task;
            TaskLineDataPane.this.dragOperation = 5;
            return true;
        }

        public boolean mouseReleased(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation != 5) {
                return false;
            }
            Task dropTask = TaskLineDataPane.this.getTaskAtPoint(e.getPoint());
            if (dropTask == null) {
                return false;
            }
            TaskLineDataPane.this.targetTask.addRestriction(dropTask);
            TaskLineDataPane.this.repaintProject();
            return true;
        }

        private void drawRestriction(Graphics g, Task from, Task to) {
            long toTime;
            int half = TaskLineDataPane.this.getCellHeight() / 2;
            int quarter = TaskLineDataPane.this.getCellHeight() / 4;
            Rectangle fromRect = TaskLineDataPane.this.getTaskRect(from);
            Rectangle toRect = TaskLineDataPane.this.getTaskRect(to);
            if (from.getStartDate() == null || from.getRealPeriod() == null || to.getStartDate() == null) {
                return;
            }
            long fromTime = from.getStartDate().getTimeInMillis() + from.getRealPeriod().longValue() * 86400000L;
            if (fromTime >= (toTime = to.getStartDate().getTimeInMillis())) {
                if (from.getIndex() < to.getIndex()) {
                    Point startingPoint = new Point(fromRect.x + fromRect.width, fromRect.y + fromRect.height / 2);
                    Point endPoint = new Point(toRect.x + quarter, toRect.y);
                    if (from.isMilestone()) {
                        startingPoint.x -= fromRect.width;
                    }
                    if (to.isMilestone()) {
                        endPoint.x -= quarter;
                    }
                    g.setColor(TaskLineDataPane.this.restrictionColor);
                    g.drawPolyline(new int[]{startingPoint.x, startingPoint.x + quarter, startingPoint.x + quarter, endPoint.x, endPoint.x}, new int[]{startingPoint.y, startingPoint.y, startingPoint.y + half, startingPoint.y + half, endPoint.y}, 5);
                    g.fillPolygon(new int[]{endPoint.x, endPoint.x - quarter, endPoint.x + quarter}, new int[]{endPoint.y, endPoint.y - quarter, endPoint.y - quarter}, 3);
                } else {
                    Point startingPoint = new Point(fromRect.x + fromRect.width, fromRect.y + fromRect.height / 2);
                    Point endPoint = new Point(toRect.x + quarter, toRect.y + toRect.height);
                    if (from.isMilestone()) {
                        startingPoint.x -= fromRect.width;
                    }
                    if (to.isMilestone()) {
                        endPoint.x -= quarter;
                    }
                    g.setColor(TaskLineDataPane.this.restrictionColor);
                    g.drawPolyline(new int[]{startingPoint.x, startingPoint.x + quarter, startingPoint.x + quarter, endPoint.x, endPoint.x}, new int[]{startingPoint.y, startingPoint.y, startingPoint.y - half, startingPoint.y - half, endPoint.y}, 5);
                    g.fillPolygon(new int[]{endPoint.x, endPoint.x - quarter - 1, endPoint.x + quarter + 1}, new int[]{endPoint.y, endPoint.y + quarter + 1, endPoint.y + quarter + 1}, 3);
                }
            } else {
                Point startingPoint = new Point(fromRect.x + fromRect.width, fromRect.y + fromRect.height / 2);
                Point endPoint = new Point(toRect.x, toRect.y + fromRect.height / 2);
                if (from.isMilestone()) {
                    startingPoint.x -= fromRect.width;
                }
                if (to.isMilestone()) {
                    endPoint.x -= quarter;
                }
                g.setColor(TaskLineDataPane.this.restrictionColor);
                g.drawPolyline(new int[]{startingPoint.x, startingPoint.x + quarter, startingPoint.x + quarter, endPoint.x}, new int[]{startingPoint.y, startingPoint.y, endPoint.y, endPoint.y}, 4);
                g.fillPolygon(new int[]{endPoint.x, endPoint.x - quarter, endPoint.x - quarter}, new int[]{endPoint.y, endPoint.y + quarter, endPoint.y - quarter}, 3);
            }
        }

        private void drawRestrictions(Graphics g) {
            for (Task from : TaskLineDataPane.this.project.getTasks()) {
                for (Task to : from.getRestrictions()) {
                    this.drawRestriction(g, from, to);
                }
            }
        }
    }

    public class TaskUI {
        public boolean mousePressed(MouseEvent e) {
            Task task = null;
            Pair<Integer, Task> operation = this.getOperation(e);
            if (operation.getFirst() == 1) {
                task = this.createTaskOperation(e);
                operation = new Pair<Integer, Task>(3, task);
            }
            TaskLineDataPane.this.targetTask = operation.getSecond();
            TaskLineDataPane.this.dragOperation = operation.getFirst();
            return true;
        }

        public boolean mouseMoved(MouseEvent e) {
            Pair<Integer, Task> operation = this.getOperation(e);
            switch (operation.getFirst()) {
                case 2: {
                    TaskLineDataPane.this.cursorState.setCursor(11);
                    return true;
                }
                case 4: {
                    TaskLineDataPane.this.cursorState.setCursor(0x7FFFFFFD);
                    return true;
                }
                case 3: {
                    TaskLineDataPane.this.cursorState.setCursor(11);
                    return true;
                }
            }
            return false;
        }

        public boolean mouseDragged(MouseEvent e) {
            if (TaskLineDataPane.this.dragOperation == 2) {
                TaskLineDataPane.this.targetTask.setStartDate(TaskLineDataPane.this.getLateBusinessDayAtPoint(e.getPoint()));
                TaskLineDataPane.this.project.update();
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 3) {
                Calendar toCalendar = TaskLineDataPane.this.getLateBusinessDayAtPoint(e.getPoint());
                int count = TaskLineDataPane.this.getBusinessDayCount(TaskLineDataPane.this.targetTask.getStartDate(), toCalendar);
                TaskLineDataPane.this.targetTask.setPeriod(count);
                TaskLineDataPane.this.project.update();
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            if (TaskLineDataPane.this.dragOperation == 4) {
                int offset = e.getX();
                Rectangle rect = TaskLineDataPane.this.getTaskRect(TaskLineDataPane.this.targetTask);
                int completion = (offset - rect.x) * 100 / rect.width / 5 * 5;
                completion = Math.min(Math.max(completion, 0), 100);
                TaskLineDataPane.this.targetTask.setCompletion(completion);
                TaskLineDataPane.this.repaintProject();
                return true;
            }
            return false;
        }

        public Pair<Integer, Task> getOperation(MouseEvent e) {
            int index = TaskLineDataPane.this.getIndexAtPoint(e.getPoint());
            Task task = TaskLineDataPane.this.project.findTask(index);
            if (task == null || task.getStartDate() == null) {
                return new Pair<Integer, Object>(1, null);
            }
            Rectangle rect = TaskLineDataPane.this.getTaskHitRect(task);
            int margin = TaskLineDataPane.this.getCellWidth() / 3 * 2;
            if (task.isMilestone()) {
                rect.x -= margin / 2;
                rect.width += margin;
            }
            int left = rect.x;
            int right = rect.x + rect.width;
            if (left <= e.getPoint().x && e.getPoint().x < left + margin) {
                return new Pair<Integer, Task>(2, task);
            }
            if (left + margin <= e.getPoint().x && e.getPoint().x < right - margin) {
                return new Pair<Integer, Task>(4, task);
            }
            if (right - margin <= e.getPoint().x && e.getPoint().x < right) {
                TaskLineDataPane.this.targetTask = task;
                return new Pair<Integer, Task>(3, task);
            }
            return new Pair<Integer, Task>(0, task);
        }

        public Task createTaskOperation(MouseEvent e) {
            int index = TaskLineDataPane.this.getIndexAtPoint(e.getPoint());
            Task task = TaskLineDataPane.this.project.findTask(index);
            if (task == null) {
                task = new Task();
                task.setIndex(index);
                task.setName("\u65b0\u898f\u30bf\u30b9\u30af");
                TaskLineDataPane.this.project.getTasks().add(task);
            }
            TaskLineDataPane.this.targetTask = task;
            if (task.getStartDate() == null) {
                task.setStartDate(TaskLineDataPane.this.getEarlyBusinessDayAtPoint(e.getPoint()));
                TaskLineDataPane.this.project.update();
                TaskLineDataPane.this.app.getTaskListPane().getTaskListTableModel().fireTableChanged();
                TaskLineDataPane.this.repaintProject();
            }
            return task;
        }
    }
}

