/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.HolidayTable;
import jp.sourceforge.freegantt.swing.HolidayTableModel;
import jp.sourceforge.freegantt.util.WrapLayout;

public class HolidayRootPane
extends JPanel {
    private static final long serialVersionUID = 2991953825084137233L;
    Application app;
    JPanel fixedList;
    HolidayTable additionalTable;
    JScrollPane additionalScrollPane;

    public HolidayRootPane(Application app) {
        this.app = app;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel fixedLabel = new JLabel("\u56fa\u5b9a\u4f11\u65e5");
        fixedLabel.setAlignmentX(0.0f);
        this.add(fixedLabel);
        this.fixedList = new JPanel();
        this.fixedList.setLayout(new WrapLayout(0));
        this.fixedList.setMaximumSize(new Dimension(Integer.MAX_VALUE, 39));
        this.fixedList.setAlignmentX(0.0f);
        this.add(this.fixedList);
        SimpleDateFormat format = new SimpleDateFormat("EEE");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 5, 0, 0, 0);
        int i = 0;
        while (i < 7) {
            final int week = (i + 1) % 7 + 1;
            final JCheckBox checkBox = new JCheckBox(format.format(calendar.getTime()));
            checkBox.setSelected(app.getProject().getFixedHolidays().contains(new Integer(week)));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List<Integer> fixedHolidays = HolidayRootPane.this.app.getProject().getFixedHolidays();
                    if (checkBox.isSelected()) {
                        fixedHolidays.remove(new Integer(week));
                        fixedHolidays.add(new Integer(week));
                    } else {
                        fixedHolidays.remove(new Integer(week));
                    }
                    HolidayRootPane.this.app.getProject().update();
                    HolidayRootPane.this.app.getProject().getTaskTableModel().fireTableChanged();
                }
            });
            this.fixedList.add(checkBox);
            calendar.add(5, 1);
            ++i;
        }
        JLabel additionalHoliday = new JLabel("\u500b\u5225\u4f11\u65e5");
        additionalHoliday.setAlignmentX(0.0f);
        this.add(additionalHoliday);
        HolidayTableModel tableModel = app.getProject().getHolidayTableModel();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                HolidayRootPane.this.app.getProject().update();
                HolidayRootPane.this.app.getProject().getTaskTableModel().fireTableChanged();
                HolidayRootPane.this.additionalTable.repaint();
            }
        });
        this.additionalTable = new HolidayTable(app, tableModel);
        this.additionalScrollPane = new JScrollPane(this.additionalTable);
        this.additionalScrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, 120));
        this.additionalScrollPane.setAlignmentX(0.0f);
        this.add(this.additionalScrollPane);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int otherHeight = 0;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c != this.additionalScrollPane) {
                otherHeight += c.getHeight();
            }
            ++n2;
        }
        Rectangle r = this.additionalScrollPane.getBounds();
        this.additionalScrollPane.setBounds(r.x, r.y, r.width, this.getHeight() - 20 - otherHeight);
    }
}

