/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.print.GanttChartPrintable;
import jp.sourceforge.freegantt.swing.Application;

public class ApplicationMenu
extends JMenuBar {
    private static final long serialVersionUID = -8682706642684252609L;
    Application application;

    public ApplicationMenu(final Application application) {
        this.application = application;
        JMenu menu = new JMenu(Resource.get("menuFile"));
        JMenuItem item = new JMenuItem(Resource.get("menuFileNew"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.newFile();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileOpen"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.loadData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSave"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.saveData();
            }
        });
        menu.add(item);
        item = new JMenuItem(Resource.get("menuFileSaveAs"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.saveAsData();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("\u30da\u30fc\u30b8\u8a2d\u5b9a");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PageFormat pageFormat = printerJob.defaultPage();
                HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
                attr.add(OrientationRequested.LANDSCAPE);
                attr.add(new PrinterResolution(600, 600, 100));
                pageFormat = printerJob.pageDialog(attr);
                application.getProject().setPageFormat(pageFormat);
            }
        });
        menu.add(item);
        item = new JMenuItem("\u5370\u5237");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterJob job = PrinterJob.getPrinterJob();
                GanttChartPrintable printable = new GanttChartPrintable(application);
                job.setPrintable(printable);
                job.setPageable(printable);
                HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
                attr.add(OrientationRequested.LANDSCAPE);
                attr.add(new PrinterResolution(600, 600, 100));
                if (job.printDialog(attr)) {
                    try {
                        job.print(attr);
                    }
                    catch (PrinterException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        menu.add(item);
        this.add(menu);
        menu = new JMenu("\u8868\u793a");
        item = new JMenuItem("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u60c5\u5831");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.openConfig(0);
            }
        });
        menu.add(item);
        item = new JMenuItem("\u30ea\u30bd\u30fc\u30b9");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.openConfig(1);
            }
        });
        menu.add(item);
        item = new JMenuItem("\u4f11\u65e5");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.openConfig(2);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("\u30da\u30fc\u30b8\u7bc4\u56f2");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                application.getTaskLineDataPane().setPrintRangeMode(!application.getTaskLineDataPane().isPrintRangeMode());
                application.getTaskLineDataPane().repaint();
            }
        });
        menu.add(item);
        this.add(menu);
    }
}

