/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.serializer.FileFormatException;
import jp.sourceforge.freegantt.data.serializer.FtgSerializer;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.swing.ApplicationMenu;
import jp.sourceforge.freegantt.swing.ConfigRootPane;
import jp.sourceforge.freegantt.swing.GanttChartPane;
import jp.sourceforge.freegantt.swing.GlobalSplitPane;
import jp.sourceforge.freegantt.swing.HolidayRootPane;
import jp.sourceforge.freegantt.swing.MemberRootPane;
import jp.sourceforge.freegantt.swing.ProjectRootPane;
import jp.sourceforge.freegantt.swing.TaskLineDataPane;
import jp.sourceforge.freegantt.swing.TaskLineHeaderPane;
import jp.sourceforge.freegantt.swing.TaskLineRootPane;
import jp.sourceforge.freegantt.swing.TaskListScrollPane;
import jp.sourceforge.freegantt.swing.TaskListTable;
import org.xml.sax.SAXException;

public class Application
extends JFrame {
    private static final long serialVersionUID = 1035207996697568561L;
    public static final String TITLE = "FreeGantt 0.0.1";
    public static final String SKELETON_FILE = "skel.fgt";
    public static final int CONFIG_PROJECT = 0;
    public static final int CONFIG_MEMBER = 1;
    public static final int CONFIG_HOLIDAY = 2;
    public static final int CONFIG_MAX = 3;
    Project project;
    int previousWindowWidth = 0;
    GlobalSplitPane globalPane;
    GanttChartPane chartPane;
    ConfigRootPane configPane;
    ProjectRootPane projectPane;
    MemberRootPane memberPane;
    HolidayRootPane holidayPane;

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public static void main(String[] args) {
        Resource.makeInstance(Locale.ENGLISH);
        Application app = new Application();
        app.setDefaultCloseOperation(3);
        app.setSize(1024, 768);
        app.setJMenuBar(new ApplicationMenu(app));
        app.setTitle(TITLE);
        app.setBackground(Color.white);
        app.setVisible(true);
        app.setProject(new Project());
        if (args.length > 0) {
            app.loadData(args[0]);
        } else {
            app.loadSkelton();
        }
        app.initialize();
    }

    public void newFile() {
        this.loadSkelton();
        this.initialize();
    }

    private void initialize() {
        this.project.updateChartRange();
        this.getContentPane().removeAll();
        this.globalPane = new GlobalSplitPane(1);
        this.globalPane.setBounds(0, 0, 1, 1);
        this.globalPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.globalPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.globalPane.setDividerSize(4);
        this.globalPane.setContinuousLayout(true);
        this.globalPane.setResizeWeight(1.0);
        this.setContentPane(this.globalPane);
        this.chartPane = new GanttChartPane(this);
        this.chartPane.setBounds(0, 0, 1, 1);
        this.chartPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.chartPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.chartPane.setLayout(null);
        this.globalPane.add(this.chartPane);
        this.configPane = new ConfigRootPane();
        this.configPane.setBounds(0, 0, 1, 1);
        this.configPane.setPreferredSize(new Dimension(0, Integer.MAX_VALUE));
        this.configPane.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.configPane.setMinimumSize(new Dimension(1, 1));
        this.configPane.setTabLayoutPolicy(1);
        this.globalPane.add(this.configPane);
        this.projectPane = new ProjectRootPane(this);
        this.projectPane.setBounds(0, 0, 300, 200);
        this.projectPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.projectPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configPane.addTab("\u60c5\u5831", this.projectPane);
        this.memberPane = new MemberRootPane(this);
        this.memberPane.setBounds(0, 0, 300, 200);
        this.memberPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.memberPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configPane.addTab("\u30ea\u30bd\u30fc\u30b9", this.memberPane);
        this.holidayPane = new HolidayRootPane(this);
        this.holidayPane.setBounds(0, 0, 300, 200);
        this.holidayPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.holidayPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.configPane.addTab("\u4f11\u65e5", this.holidayPane);
        this.configPane.validate();
        this.globalPane.setDividerLocation(1.0);
        this.getTaskLineRootPane().initializeViewportOffset();
    }

    public void saveData(String filename) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(filename);
                new FtgSerializer().write(this.project, out);
                out.close();
                this.setTitle("FreeGantt 0.0.1 - " + filename);
                this.project.setFilename(filename);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "\u30d5\u30a1\u30a4\u30eb\u306e\u64cd\u4f5c\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a1\u30a4\u30eb\u30a8\u30e9\u30fc", 0);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void saveData() {
        if (this.project.getFilename() == null) {
            this.saveAsData();
        } else {
            this.saveData(this.project.getFilename());
        }
    }

    public void saveAsData() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("freegantt\u30d5\u30a1\u30a4\u30eb", "fgt");
        chooser.setFileFilter(filter);
        int ret = chooser.showSaveDialog(this);
        if (ret == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            if (!filename.endsWith(".fgt")) {
                filename = filename.concat(".fgt");
            }
            this.saveData(filename);
        }
    }

    public void loadSkelton() {
        if (new File(SKELETON_FILE).exists()) {
            this.loadData(SKELETON_FILE);
            this.project.setFilename(null);
        } else {
            this.project = new Project();
        }
    }

    /*
     * Loose catch block
     */
    public void loadData(String filename) {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(filename);
                Project project = new Project();
                new FtgSerializer().read(project, in);
                in.close();
                this.setTitle("FreeGantt 0.0.1 - " + filename);
                this.project = project;
                this.project.setFilename(filename);
                this.project.update();
                this.initialize();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "FreeGantt\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (SAXException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "FreeGantt\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (FileFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "FreeGantt\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void loadData() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("freegantt\u30d5\u30a1\u30a4\u30eb", "fgt");
        chooser.setFileFilter(filter);
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.loadData(filename);
        }
    }

    public TaskLineDataPane getTaskLineDataPane() {
        if (this.chartPane == null || this.chartPane.getTaskLineRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskLineRootPane().getTaskLineDataPane();
    }

    public JViewport getDataViewport() {
        if (this.chartPane == null || this.chartPane.getTaskLineRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskLineRootPane().getDataViewport();
    }

    public TaskListTable getTaskListPane() {
        if (this.chartPane == null || this.chartPane.getTaskListRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskListRootPane().getTaskListPane();
    }

    public TaskListScrollPane getTaskListScrollPane() {
        if (this.chartPane == null || this.chartPane.getTaskListRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskListRootPane().getTaskListScrollPane();
    }

    public GanttChartPane getGanttChartPane() {
        return this.chartPane;
    }

    public TaskLineRootPane getTaskLineRootPane() {
        return this.chartPane.getTaskLineRootPane();
    }

    public TaskLineHeaderPane getTaskLineHeaderPane() {
        if (this.chartPane == null || this.chartPane.getTaskListRootPane() == null) {
            return null;
        }
        return this.chartPane.getTaskLineRootPane().getTaskLineHeaderPane();
    }

    @Override
    public void doLayout() {
        int chartWidth = 0;
        int width = 0;
        if (this.globalPane != null) {
            chartWidth = this.globalPane.getDividerLocation();
            width = this.globalPane.getSize().width;
        }
        super.doLayout();
        if (this.globalPane != null) {
            int newChartWidth = Math.max(chartWidth + this.globalPane.getSize().width - width, 0);
            this.globalPane.setDividerLocation(newChartWidth);
        }
    }

    public void openConfig(int type) {
        this.configPane.setSelectedIndex(type);
        int location = this.globalPane.getWidth() - 200;
        this.globalPane.setDividerLocation(location);
    }
}

