<?php
/*
 * framework-spider: Webページ利用用共通メイン実行ファイル
 */
// Framework Version
define( 'SPIDER_VERSION', '1.0.00' );

/* 設定ファイルの読み込み	*/
require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.inc.php' );
require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'messages.inc.php' );
if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}
// システムメール定義ファイルの読み込み
if( defined('FILE_PATH_SYSTEM_DEFINITION') && file_exists( FILE_PATH_SYSTEM_DEFINITION ) ){
	require_once( FILE_PATH_SYSTEM_DEFINITION );
}

// アクションファイルパスの取得
$action_file_path = $_SERVER["SCRIPT_FILENAME"];
if ( str_replace( "\\", "/", __FILE__ )
	== str_replace( "\\", "/", $action_file_path ) ) {
	// 本ファイル直接呼出しなら実行中止
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( "Core Error : コントロールファイルです。" );
}

/* リクエストコンテナオブジェクト	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider"
	. DIRECTORY_SEPARATOR . "HttpRequest.class.php" );
$GLOBALS['request_object']	= new spider_HttpRequest();

/* 出力クラス	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider" 
	. DIRECTORY_SEPARATOR . "HttpOutput.class.php" );
$GLOBALS['output_object']		= new spider_HttpOutput();

/* コントローラークラス	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider" 
	. DIRECTORY_SEPARATOR . "Controller.class.php" );

/* グローバル関数ファイル	*/
require_once( DIR_PATH_LIB
	. DIRECTORY_SEPARATOR . "spider" 
	. DIRECTORY_SEPARATOR . "functions.inc.php" );

/* パーミッションの確認	*/
$errors	= spider_is_avairable_permittion();
if( count( $errors ) > 0 ) {
	header( 'Content-Type: text/plain;charset=UTF-8');
	echo "Core Error!!\n";
	foreach( $errors as $error ) {
		echo $error."\n";
	}
	die;
}

// POSTとGETとCOOKIEの値をオブジェクトに設定する
foreach( $_POST as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'post.'.$key, $value );
}
foreach( $_GET as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'get.'.$key, $value );
}
foreach( $_COOKIE as $key => $value ) {
	$GLOBALS['request_object']->setAttribute( 'cookie.'.$key, $value );
}
// sessionのnameとidをリクエストに登録する
$GLOBALS['request_object']->setAttribute( 'spider.session_name', session_name() );
$GLOBALS['request_object']->setAttribute( 'spider.session_id', session_id() );

// spiderの固定値をリクエスト属性に設定する
$base_url = APPLICATION_BASE_URL;
$GLOBALS['request_object']->setAttribute( 'spider.base_url', $base_url );
$nomal_url = APPLICATION_NML_URL;
$GLOBALS['request_object']->setAttribute( 'spider.nomal_url', $nomal_url );
$ssl_url = APPLICATION_SSL_URL;
$GLOBALS['request_object']->setAttribute( 'spider.ssl_url', $ssl_url );
$base_uri = APPLICATION_BASE_URI;
$GLOBALS['request_object']->setAttribute( 'spider.base_uri', $base_uri );
$base_path = APPLICATION_BASE_PATH;
$GLOBALS['request_object']->setAttribute( 'spider.base_path', $base_path );

// コントローラー
$GLOBALS['controller']	= new spider_Controller( $GLOBALS['request_object'], $GLOBALS['output_object'] );
// 前処理スクリプトの指定があるなら読み込む
if( is_array($GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY'])
	&& count($GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY']) > 0 ) {
	foreach( $GLOBALS['SPIDER_PREVIOUS_SCRIPT_FILE_PATH_ARRAY'] as $script_path ) {
		$script_path	= trim( $script_path );
		if( strlen($script_path) > 0 && file_exists( $script_path) ) {
			include_once( $script_path );
		}
	}
}
// メイン処理実行
$GLOBALS['controller']->execute( $GLOBALS['request_object'], $GLOBALS['output_object'] );

die;

?>
