<?php
/**
 * ファイルシステムに関するユーティリティ関数群を提供する静的メソッドクラス
 */
class util_File {
	/**
	 * 指定フォルダ以下のフォルダとファイルを指定フォルダ化にコピーします
	 * @param $resource_dir コピー元フォルダパス
	 * @param $destination_dir コピー先フォルダパス
	 */
	function copyDirFiles( $resource_dir, $destination_dir, $force=false ) {
		if( is_dir( $resource_dir ) && is_dir($destination_dir) ) {
			if ($dh = opendir($resource_dir)) {
				while (($file_name = readdir($dh)) !== false) {
					if( preg_match('/^\\./',$file_name) == 0 ) {
						$file_absolute_path	= $resource_dir.DIRECTORY_SEPARATOR.$file_name;
						$file_type			= filetype($file_absolute_path);
						$destination_path	= $destination_dir.DIRECTORY_SEPARATOR.$file_name;
						if( preg_match('/^[dD][iI][rR]/', filetype($file_absolute_path) ) ) {
							// フォルダの場合なければ作成する
							if( !file_exists($destination_path) ) {
								if( @mkdir( $destination_path, 0777 ) ) {
									@chmod( $destination_path, 0777 );
								} else {
									return false;
								}
							}
							// 再帰呼び出し
							if( !util_File::copyDirFiles( $file_absolute_path, $destination_path ) ) {
								return false;
							}
						} else if( preg_match('/^[fF][iI][lL][eE]/', filetype($file_absolute_path) ) ) {
							// 対象がファイルの場合なければコピー
							if( $force || !file_exists($destination_path) ) {
								if( @copy( $file_absolute_path, $destination_path ) ) {
									@chmod( $destination_path, 0777 );
								} else {
									return false;
								}
							}
						}
					}
				}
				@closedir( $dh );
			}
		} else {
			return false;
		}
		return true;
	}
}
?>