<?php
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR."ModuleBase.class.php");
/**
 * spider：POSTおよびGETで入力されたパラメータの文字コードを全てUTF-8に変換する
 * アクションモジュールクラス
 * 
 * @package spider spider/moduleパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_module_AutoEncode extends spider_ModuleBase {
	function spider_module_AutoEncode() {
	}
	function execute( & $request ) {
		$strings		= implode('',$_POST).implode('',$_GET);
		$input_charset	= mb_detect_encoding($strings,'auto');
		if( $input_charset != 'UTF-8' ) {
			// POSTパラメータ
			foreach( $_POST as $key => $val ) {
				if ( is_array($val) ) {
					if( preg_match('/^[aA][sS][cC][iI][iI]$/',mb_detect_encoding($val,'auto')) == 0 ) {
						$_POST[$key]	= mb_convert_variables('UTF-8',$input_charset,$val);
					}
				} else {
					if( preg_match('/^[aA][sS][cC][iI][iI]$/',mb_detect_encoding($val,'auto')) == 0 ) {
						$_POST[$key]	= mb_convert_encoding($val,'UTF-8',$input_charset);
					}
				}
			}
			// GETパラメータ
			foreach( $_GET as $key => $val ) {
				if ( is_array($val) ) {
					if( preg_match('/^[aA][sS][cC][iI][iI]$/',mb_detect_encoding($val,'auto')) == 0 ) {
						$_GET[$key]	= mb_convert_variables('UTF-8',$input_charset,$val);
					}
				} else {
					if( preg_match('/^[aA][sS][cC][iI][iI]$/',mb_detect_encoding($val,'auto')) == 0 ) {
						$_GET[$key]	= mb_convert_encoding($val,'UTF-8',$input_charset);
					}
				}
			}
		}
	}
}
?>
