<?php
/*
 * framework-spider: 基本設定記述ファイル
 */
// セッション機能 ( true=spiderのセッションID発行機能を使う / false=PHP標準を使う )
// ※PHPのセッションID発行機能はIDが重複するバグがありますが、spiderの発行機能は環境によっては利用できません。
define( 'SPIDER_USE_SPIDER_SESSION_ID',	false );

/*
 * ユーザーエージェント分岐定義
 */
// 分岐タイプ定義 分類ID=>分類名称
$GLOBALS['SPIDER_USER_AGENT_CLASS_HASH']	= array(
	'au'			=> 'au',
	'softbank'		=> 'SoftBank',
	'docomo2'		=> 'DoCoMo2.0',
	'docomo'		=> 'DoCoMo1.0',
	'default'		=> 'Default',
);
// 分岐タイプにファイルが存在しなかった場合の代替タイプ定義
$GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH']	= array(
	'au'			=> 'docomo2',
	'softbank'		=> 'docomo2',
);
// ユーザーエージェント正規表現による分岐タイプ 正規表現=>分類ID
$GLOBALS['SPIDER_USER_AGENT_CLASS_REGX_HASH']	= array(
	'/^KDDI\\-/'							=> 'au',
	'/^UP\\.Browser\\/[0-9\\.]+\\-/'	=> 'au',
	'/^J\\-PHONE/'						=> 'softbank',
	'/^Vodafone/'							=> 'softbank',
	'/^SoftBank/'							=> 'softbank',
	'/^DoCoMo\\/2/'						=> 'docomo2',
	'/^DoCoMo\\/1/'						=> 'docomo',
);

/*
 * 拡張設定
 */
// ライブラリディレクトリ名
define ( 'DIR_NAME_LIB',				'lib' );
// テンプレート配置ディレクトリ名
define ( 'DIR_NAME_TEMPLATES',		'templates' );
// ウィジェットディレクトリ名
define ( 'DIR_NAME_WIDGET',			'widgets' );
// データ保存ディレクトリ名
define ( 'DIR_NAME_DATA',				'data' );
// ワークディレクトリ名
define ( 'DIR_NAME_WORK',				'work' );
// アプリケーションログ保存ディレクトリ
define ( 'DIR_NAME_LOG',				'logs' );

// ビルドファイル配置ディレクトリ名
define ( 'DIR_NAME_BIN',				'bin' );
// ロックディレクトリ名
define ( 'DIR_NAME_LOCK',				'lock' );
// キャッシュディレクトリ名
define ( 'DIR_NAME_CACHE',			'cache' );
// テンポラリディレクトリ名
define ( 'DIR_NAME_TMP',				'tmp' );

/*
 * 基本定義 
 */
// ライブラリフォルダの絶対パス
define( 'DIR_PATH_LIB', DIR_PATH_SPIDER_DATA.DIRECTORY_SEPARATOR.DIR_NAME_LIB );
// テンプレートディレクトリパス
define( 'DIR_PATH_TEMPLATES', DIR_PATH_SPIDER_DATA.DIRECTORY_SEPARATOR.DIR_NAME_TEMPLATES );
// ウィジェットディレクトリパス
define( 'DIR_PATH_WIDGETS',DIR_PATH_SPIDER_DATA.DIRECTORY_SEPARATOR.DIR_NAME_WIDGET);
// データ保存ディレクトリ
define( 'DIR_PATH_DATA', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_DATA );
// ワークディレクトリパス
define( 'DIR_PATH_WORK', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_WORK );

// アプリケーションログ保存ディレクトリパス
define( 'DIR_PATH_LOG',	DIR_PATH_DATA . DIRECTORY_SEPARATOR . DIR_NAME_LOG );
// バイナリディレクトリパス
define( 'DIR_PATH_BIN',	DIR_PATH_WORK . DIRECTORY_SEPARATOR . DIR_NAME_BIN );
// プロセスロックの一時フォルダ
define ( 'DIR_PATH_LOCK', DIR_PATH_WORK . DIRECTORY_SEPARATOR . DIR_NAME_LOCK );
// キャッシュディレクトリパス
define( 'DIR_PATH_CACHE',	DIR_PATH_WORK . DIRECTORY_SEPARATOR . DIR_NAME_CACHE );
// 全体で利用する一時フォルダ
define ( 'DIR_PATH_TMP', DIR_PATH_WORK . DIRECTORY_SEPARATOR . DIR_NAME_TMP );

// ページ振り分けファイル配置ディレクトリ
if( defined('DIR_NAME_PAGES') && strlen(DIR_NAME_PAGES) > 0 ) {
	define( 'DIR_PATH_PAGES', DIR_PATH_SPIDER_DATA.DIRECTORY_SEPARATOR.DIR_NAME_PAGES );
}

/*
 * システムレポートとメール通知設定
 */
// ログ出力レベルの定義
define('SPIDER_LOG_LEVEL_FATAL',	0);
define('SPIDER_LOG_LEVEL_ERROR',	10);
define('SPIDER_LOG_LEVEL_WARNING',	20);
define('SPIDER_LOG_LEVEL_NOTICE',	30);
define('SPIDER_LOG_LEVEL_INFO',		40);
define('SPIDER_LOG_LEVEL_DEBUG',	50);
// ログ出力先の定義
define('SPIDER_LOG_TYPE_FILE',		0);
define('SPIDER_LOG_TYPE_SYSLOG',	10);

// システムメール定義ファイル名
define ( 'FILE_NAME_SYSTEM_DEFINITION',	'system.inc.php' );
// システムメール定義ファイルパス
define ( 'FILE_PATH_SYSTEM_DEFINITION',	DIR_PATH_DATA.DIRECTORY_SEPARATOR.FILE_NAME_SYSTEM_DEFINITION );

?>
