/*
 * Decompiled with CFR 0.152.
 */
package jp.fraction.hatena.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.fraction.hatena.HatenaContext;
import jp.fraction.hatena.node.PatternNode;
import jp.fraction.hatena.node.SectionNode;

public class TagNode
extends SectionNode
implements PatternNode {
    private Pattern pattern = Pattern.compile("^>(<.*)$");
    private Pattern endPattern = Pattern.compile("^(.*>)<$");

    public PatternNode[] getChildNodes() {
        return new PatternNode[]{HatenaContext.H5_NODE, HatenaContext.H4_NODE, HatenaContext.BLOCKQUOTE_NODE, HatenaContext.DL_NODE, HatenaContext.LIST_NODE, HatenaContext.PRE_NODE, HatenaContext.SUPER_PRE_NODE, HatenaContext.TABLE_NODE};
    }

    public Pattern getEndPattern() {
        return this.endPattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Matcher getMatcher(String line) {
        return this.getPattern().matcher(line);
    }

    public StringBuilder parse(StringBuilder html, HatenaContext c) {
        String line = c.nextLine();
        Matcher m = this.getMatcher(line);
        if (!m.matches()) {
            return html;
        }
        c.shiftLine();
        c.setNoParagraph(true);
        html.append(this.parseText(m.group(1)));
        while (c.hasNext()) {
            line = c.nextLine();
            Matcher em = this.getEndPattern().matcher(line);
            if (em.matches()) {
                c.shiftLine();
                html.append(this.parseText(m.group(1)));
                break;
            }
            this.parseLine(html, c);
        }
        c.setNoParagraph(false);
        return html;
    }

    protected String parseText(String text) {
        return HatenaContext.HATENA_TEXT.parse(text);
    }
}

