/*
 * Decompiled with CFR 0.152.
 */
package jp.fraction.hatena.node;

import java.util.regex.Matcher;
import jp.fraction.hatena.HatenaContext;
import jp.fraction.hatena.node.Node;
import jp.fraction.hatena.node.PatternNode;

public class SectionNode
implements Node {
    private static final String START = "<div class=\"section\">";
    private static final String END = "</div>";

    public PatternNode[] getChildNodes() {
        return new PatternNode[]{HatenaContext.H5_NODE, HatenaContext.H4_NODE, HatenaContext.H3_NODE, HatenaContext.BLOCKQUOTE_NODE, HatenaContext.DL_NODE, HatenaContext.LIST_NODE, HatenaContext.PRE_NODE, HatenaContext.SUPER_PRE_NODE, HatenaContext.TABLE_NODE, HatenaContext.TAG_NODE};
    }

    public StringBuilder parse(StringBuilder html, HatenaContext context) {
        html.append(START);
        while (context.hasNext()) {
            html = this.parseLine(html, context);
        }
        html.append(END);
        return html;
    }

    protected StringBuilder parseLine(StringBuilder html, HatenaContext context) {
        String line = context.nextLine();
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            PatternNode n = this.getChildNodes()[i];
            Matcher m = n.getMatcher(line);
            if (!m.matches()) continue;
            return n.parse(html, context);
        }
        if (line.length() == 0) {
            return HatenaContext.BR_NODE.parse(html, context);
        }
        if (context.isNoParagraph()) {
            return HatenaContext.CDATA_NODE.parse(html, context);
        }
        return HatenaContext.P_NODE.parse(html, context);
    }
}

