/*
 * Decompiled with CFR 0.152.
 */
package jp.fraction.hatena.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.fraction.hatena.HatenaContext;
import jp.fraction.hatena.node.AbstractPatternNode;

public class PreNode
extends AbstractPatternNode {
    private Pattern pattern = Pattern.compile("^>\\|$");
    private Pattern endPattern = Pattern.compile("(.*)\\|<$");
    private String startTag = "<pre>";
    private String endTag = "</pre>";

    public Pattern getEndPattern() {
        return this.endPattern;
    }

    public String getEndTag() {
        return this.endTag;
    }

    public String getStartTag() {
        return this.startTag;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public StringBuilder parse(StringBuilder html, HatenaContext c) {
        c.shiftLine();
        html.append(this.getStartTag());
        String endLine = "";
        while (c.hasNext()) {
            String line = c.nextLine();
            Matcher endMatch = this.getEndPattern().matcher(line);
            if (endMatch.matches()) {
                endLine = endMatch.group(1);
                c.shiftLine();
                break;
            }
            html.append(this.escape(line));
            c.shiftLine();
        }
        html.append(endLine);
        html.append(this.getEndTag());
        return html;
    }

    protected String escape(String text) {
        return text;
    }
}

