/*
 * Decompiled with CFR 0.152.
 */
package jp.fraction.hatena.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.fraction.hatena.HatenaContext;
import jp.fraction.hatena.node.PatternNode;
import jp.fraction.hatena.node.SectionNode;

public class BlockquoteNode
extends SectionNode
implements PatternNode {
    private Pattern pattern = Pattern.compile("^>>$");
    private Pattern endPattern = Pattern.compile("^<<$");
    private String startTag = "<blockquote>";
    private String endTag = "</blockquote>";

    public String getEndTag() {
        return this.endTag;
    }

    public String getStartTag() {
        return this.startTag;
    }

    public PatternNode[] getChildNodes() {
        return new PatternNode[]{HatenaContext.H5_NODE, HatenaContext.H4_NODE, HatenaContext.BLOCKQUOTE_NODE, HatenaContext.DL_NODE, HatenaContext.LIST_NODE, HatenaContext.PRE_NODE, HatenaContext.SUPER_PRE_NODE, HatenaContext.TABLE_NODE};
    }

    public Pattern getEndPattern() {
        return this.endPattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public StringBuilder parse(StringBuilder html, HatenaContext context) {
        context.shiftLine();
        html.append(this.getStartTag());
        while (context.hasNext()) {
            String line = context.nextLine();
            if (this.getEndPattern().matcher(line).matches()) {
                context.shiftLine();
                break;
            }
            html = this.parseLine(html, context);
        }
        html.append(this.getEndPattern());
        return html;
    }

    public Matcher getMatcher(String line) {
        return this.getPattern().matcher(line);
    }
}

