/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.myid3;

import java.io.UnsupportedEncodingException;
import org.cmc.music.common.ID3v1Genre;
import org.cmc.music.metadata.MusicMetadata;
import org.cmc.music.metadata.MusicMetadataConstants;
import org.cmc.music.myid3.MyID3Listener;

public class MyID3v1
implements MusicMetadataConstants {
    private static final String DEFAULT_CHAR_ENCODING = "UTF-8";

    public byte[] toTag(MusicMetadata values) throws UnsupportedEncodingException {
        String genre_name;
        Number genre_id;
        byte[] result = new byte[128];
        int index = 0;
        result[index++] = 84;
        result[index++] = 65;
        result[index++] = 71;
        this.writeField(result, index, 30, (String)values.get("title"));
        this.writeField(result, index += 30, 30, (String)values.get("artist"));
        this.writeField(result, index += 30, 30, (String)values.get("album"));
        index += 30;
        Object o = values.get("year");
        Number value = null;
        if (o != null) {
            if (o instanceof Number) {
                value = (Number)values.get("year");
            } else if (o instanceof String) {
                String s = (String)o;
                try {
                    value = Integer.valueOf(s);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.writeField(result, index, 4, value == null ? null : "" + value);
            }
        }
        index += 4;
        Number track_number = null;
        value = (Number)values.get("track_number");
        if (value != null && value.intValue() >= 0 && value.intValue() < 256) {
            track_number = value;
        }
        if (track_number == null) {
            this.writeField(result, index, 30, (String)values.get("comment"));
            index += 30;
        } else {
            this.writeField(result, index, 28, (String)values.get("comment"));
            index += 28;
            result[index++] = 0;
            result[index++] = (byte)track_number.intValue();
        }
        Object o2 = values.get("genre_id");
        if (o2 == null) {
            o2 = values.get("genre");
        }
        if (o2 != null && o2 instanceof String && (genre_id = ID3v1Genre.get(genre_name = (String)o2)) != null) {
            o2 = genre_id;
        }
        if (o2 == null || o2 instanceof Number) {
            Number value2 = (Number)o2;
            result[index++] = value2 != null && value2.intValue() >= 0 && value2.intValue() < 80 ? (byte)value2.intValue() : (byte)0;
        }
        return result;
    }

    private void writeField(byte[] bytes, int start, int max_length, String s) throws UnsupportedEncodingException {
        if (s == null) {
            int i = 0;
            while (i < max_length) {
                bytes[i + start] = 0;
                ++i;
            }
            return;
        }
        byte[] value = s.getBytes(DEFAULT_CHAR_ENCODING);
        int count = Math.min(value.length, max_length);
        int i = 0;
        while (i < count) {
            bytes[i + start] = value[i];
            ++i;
        }
        i = count;
        while (i < max_length) {
            bytes[i + start] = 0;
            ++i;
        }
    }

    private String getField(MyID3Listener listener, byte[] bytes, int start, int length) {
        int i = start;
        while (i < start + length) {
            if (bytes[i] == 0) {
                length = i - start;
                break;
            }
            ++i;
        }
        if (length > 0) {
            String result;
            block6: {
                result = new String(bytes, start, length, DEFAULT_CHAR_ENCODING);
                result = result.trim();
                if (result.length() >= 1) break block6;
                return null;
            }
            try {
                return result;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public MusicMetadata parseTags(byte[] bytes) {
        return this.parseTags(null, bytes);
    }

    public MusicMetadata parseTags(MyID3Listener listener, byte[] bytes) {
        int genre;
        MusicMetadata tags = new MusicMetadata("id3v1");
        int counter = 3;
        String title = this.getField(listener, bytes, counter, 30);
        counter += 30;
        tags.put("title", title);
        if (listener != null) {
            listener.logWithLength("id3v1 title", title);
        }
        String artist = this.getField(listener, bytes, counter, 30);
        counter += 30;
        tags.put("artist", artist);
        if (listener != null) {
            listener.logWithLength("id3v1 artist", artist);
        }
        String album = this.getField(listener, bytes, counter, 30);
        counter += 30;
        tags.put("album", album);
        if (listener != null) {
            listener.logWithLength("id3v1 album", album);
        }
        String year = this.getField(listener, bytes, counter, 4);
        counter += 4;
        tags.put("year", year);
        if (listener != null) {
            listener.logWithLength("id3v1 year", year);
        }
        String comment = this.getField(listener, bytes, counter, 30);
        counter += 30;
        tags.put("comment", comment);
        if (listener != null) {
            listener.logWithLength("id3v1 comment", comment);
        }
        if (bytes[counter - 2] == 0 && bytes[counter - 1] != 0) {
            int trackNumber = 0xFF & bytes[counter - 1];
            tags.put("track_number", new Integer(trackNumber));
            if (listener != null) {
                listener.log("id3v1 trackNumber: " + trackNumber);
            }
        }
        if ((genre = 0xFF & bytes[counter]) < 80 && genre > 0) {
            tags.put("genre_id", new Integer(genre));
            if (listener != null) {
                listener.log("id3v1 genre: " + genre);
            }
        }
        if (listener != null) {
            listener.log();
        }
        return tags;
    }
}

