/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.myid3;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.regexp.RE;
import org.cmc.music.common.ID3FrameType;
import org.cmc.music.common.ID3v1Genre;
import org.cmc.music.metadata.ImageData;
import org.cmc.music.metadata.MusicMetadata;
import org.cmc.music.metadata.MusicMetadataConstants;
import org.cmc.music.myid3.MyID3v2FrameImage;
import org.cmc.music.myid3.MyID3v2FrameText;

public class ID3v2DataMapping
implements MusicMetadataConstants {
    private static final ID3v2TagHandler[] handlers = new ID3v2TagHandler[]{new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.COMMENT;
        }

        protected Object getKey() {
            return "comment";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.ALBUM;
        }

        protected Object getKey() {
            return "album";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.ARTIST;
        }

        protected Object getKey() {
            return "artist";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.TITLE;
        }

        protected Object getKey() {
            return "title";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.CONTENTTYPE;
        }

        protected Object getKey() {
            return null;
        }

        public void process(MusicMetadata values, MyID3v2FrameText tag) {
            String value = tag.value;
            try {
                if (value == null || value.trim().length() < 1) {
                    return;
                }
                boolean id_only = new RE("^\\(\\d+\\)").match(value);
                if (id_only) {
                    int index = value.indexOf(41);
                    String number = value.substring(1, index);
                    if (ID3v2DataMapping.isNumber(number = number.trim())) {
                        Integer id = new Integer(number);
                        if (id != 0) {
                            values.put("genre_id", id);
                            String genre = ID3v1Genre.get(id);
                            if (genre != null) {
                                values.put("genre", genre);
                            }
                        }
                        value = value.substring(index + 1);
                    }
                } else {
                    boolean numeric_only = new RE("^\\d+$").match(value);
                    if (numeric_only) {
                        Integer id = new Integer(value);
                        if (id != 0) {
                            values.put("genre_id", id);
                            String genre = ID3v1Genre.get(id);
                            if (genre != null) {
                                values.put("genre", genre);
                            }
                        }
                        value = "";
                    }
                }
                if (value.length() > 0) {
                    values.put("genre", value);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.PUBLISHER;
        }

        protected Object getKey() {
            return "publisher";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.YEAR;
        }

        protected Object getKey() {
            return "year";
        }

        public void process(MusicMetadata values, MyID3v2FrameText tag) {
            try {
                String value = tag.value;
                if (value == null || value.trim().length() < 1) {
                    return;
                }
                if (!ID3v2DataMapping.isNumber(value = value.trim())) {
                    return;
                }
                Integer number = Integer.valueOf(value);
                values.put("year", number);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.TRACKNUM;
        }

        protected Object getKey() {
            return "track_number";
        }

        public void process(MusicMetadata values, MyID3v2FrameText tag) {
            try {
                String value = tag.value;
                if (value == null || value.trim().length() < 1) {
                    return;
                }
                if (value.indexOf(47) >= 0) {
                    try {
                        String s = value.substring(value.indexOf(47) + 1);
                        s = s.trim();
                        if (ID3v2DataMapping.isNumber(s)) {
                            Integer track_count = new Integer(s);
                            values.put("track_count", track_count);
                        }
                    }
                    catch (Throwable s) {
                        // empty catch block
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (ID3v2DataMapping.isNumber(value = value.trim())) {
                    Integer number = new Integer(value);
                    values.put("track_number", number);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.SONGLEN;
        }

        protected Object getKey() {
            return "duration_seconds";
        }

        public void process(MusicMetadata values, MyID3v2FrameText tag) {
            try {
                String value = tag.value;
                if (value == null || value.trim().length() < 1) {
                    return;
                }
                Long number = new Long(value);
                if (((Number)(number = new Long(number / 1000L))).intValue() == 0) {
                    return;
                }
                values.put("duration_seconds", number);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.COMPOSER;
        }

        protected Object getKey() {
            return "composer";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.CONDUCTOR;
        }

        protected Object getKey() {
            return "conductor";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.BAND;
        }

        protected Object getKey() {
            return "band";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.MIXARTIST;
        }

        protected Object getKey() {
            return "mix_artist";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.LYRICIST;
        }

        protected Object getKey() {
            return "lyricist";
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.USERTEXT;
        }

        protected Object getKey() {
            return null;
        }

        public void process(MusicMetadata values, MyID3v2FrameText tag) {
            if (tag.value == null || tag.value2 == null) {
                return;
            }
            String key = tag.value;
            String value = tag.value2;
            if (key.equalsIgnoreCase("engineer")) {
                values.put("engineer", value);
            } else if (key.equalsIgnoreCase("Rip date") || key.equalsIgnoreCase("Ripping tool") || key.equalsIgnoreCase("TraktorID") || key.equalsIgnoreCase("TraktorPeakDB") || key.equalsIgnoreCase("TraktorPerceivedDB") || key.equalsIgnoreCase("fBPMQuality") || key.equalsIgnoreCase("TraktorReleaseDate")) {
                // empty if block
            }
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.ENCODEDBY;
        }

        protected Object getKey() {
            return null;
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.ENCODERSETTINGS;
        }

        protected Object getKey() {
            return null;
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.MEDIATYPE;
        }

        protected Object getKey() {
            return null;
        }
    }, new ID3v2TagHandler(){

        protected ID3FrameType getFrameType() {
            return ID3FrameType.FILETYPE;
        }

        protected Object getKey() {
            return null;
        }
    }};
    private static final Map keyToFrameTypeMap = new HashMap();
    private static final Vector ignoredFrameTypes = new Vector();

    static {
        int i = 0;
        while (i < handlers.length) {
            ID3v2TagHandler handler = handlers[i];
            Object key = handler.getKey();
            if (key != null) {
                keyToFrameTypeMap.put(key, handler.getFrameType());
            } else {
                ignoredFrameTypes.add(handler.getFrameType());
            }
            ++i;
        }
    }

    public ID3FrameType getID3FrameType(Object key) {
        if (key.equals("pictures")) {
            return ID3FrameType.PICTURE;
        }
        return (ID3FrameType)keyToFrameTypeMap.get(key);
    }

    public boolean isIgnoredID3FrameType(ID3FrameType frame_type) {
        return ignoredFrameTypes.contains(frame_type);
    }

    public MusicMetadata process(Vector tags) {
        if (tags == null) {
            return null;
        }
        try {
            MusicMetadata result = new MusicMetadata("id3v2");
            int i = 0;
            while (i < tags.size()) {
                Object o = tags.get(i);
                if (o instanceof MyID3v2FrameImage) {
                    MyID3v2FrameImage imageFrame = (MyID3v2FrameImage)o;
                    ImageData imageData = imageFrame.getImageData();
                    result.addPicture(imageData);
                } else if (o instanceof MyID3v2FrameText) {
                    MyID3v2FrameText tag = (MyID3v2FrameText)tags.get(i);
                    this.process(result, tag);
                }
                ++i;
            }
            return result;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void process(MusicMetadata values, MyID3v2FrameText tag) {
        int i = 0;
        while (i < handlers.length) {
            ID3v2TagHandler handler = handlers[i];
            if (handler.matches(tag.frame_id)) {
                handler.process(values, tag);
                return;
            }
            ++i;
        }
    }

    private static boolean isNumber(String s) {
        boolean result = new RE("^-?[0-9]+$").match(s);
        return result;
    }

    private static abstract class ID3v2TagHandler {
        private ID3v2TagHandler() {
        }

        protected abstract ID3FrameType getFrameType();

        protected abstract Object getKey();

        public boolean matches(String s) {
            return this.getFrameType().matches(s);
        }

        public void process(MusicMetadata values, MyID3v2FrameText tag) {
            Object key = this.getKey();
            if (key == null) {
                return;
            }
            values.put(key, tag.value);
        }
    }
}

