package jp.sourceforge.fosj.loan.calculators;


import java.math.BigDecimal;
import java.util.ArrayList;

import jp.sourceforge.fosj.loan.model.Loan;
import jp.sourceforge.fosj.loan.model.Payment;

public class DifferentiatedCalculator extends AbstractCalculator {
    private static final BigDecimal TWO = new BigDecimal(2);

    public void calculate(Loan loan) {
        BigDecimal amount = calculateAmountWithDownPayment(loan);
        loan.setResiduePayment(getResiduePayment(loan));
        boolean hasResidue = loan.getResiduePayment().compareTo( BigDecimal.ZERO) > 0;
        addDisposableCommission(loan, amount);

        BigDecimal interestMonthly = loan.getInterest().divide(new BigDecimal("1200"), SCALE, MODE);
        Integer period = hasResidue ?  loan.getPeriod() - 1 : loan.getPeriod();
        BigDecimal residueInterest = hasResidue? loan.getResiduePayment().multiply(interestMonthly).setScale(loan.getScale(), MODE) : BigDecimal.ZERO;

        BigDecimal monthlyAmount = amount.subtract(loan.getResiduePayment()).divide(new BigDecimal(period), loan.getScale(), MODE);
        BigDecimal currentAmount = amount;
        ArrayList<Payment> payments = new ArrayList<Payment>();
        int i = 0 ;
        for (; i < period; i++) {
            BigDecimal interest = currentAmount.multiply(interestMonthly).setScale(loan.getScale(), MODE);
            BigDecimal payment = interest.add(monthlyAmount);

            Payment p = new Payment();
            p.setNr(i + 1);
            p.setInterest(interest);
            p.setPrincipal(monthlyAmount);
            p.setBalance(currentAmount);
            // adjust fractional amount
            if (hasResidue){
                if (i == period - 1) {
                    BigDecimal lastPrincipal = currentAmount.subtract(loan.getResiduePayment());
                    payment = payment.add(lastPrincipal).subtract(monthlyAmount);
                    p.setPrincipal(lastPrincipal);
                    monthlyAmount = lastPrincipal;
                }
            } else {
                if (i == period - 1) {
                	BigDecimal lastPrincipal = currentAmount;
                    payment = payment.add(lastPrincipal).subtract(monthlyAmount);
                    p.setPrincipal(lastPrincipal);
                    monthlyAmount = lastPrincipal;
                }
            }

            addPaymentWithCommission(loan, p, payment);

            payments.add(p);

            currentAmount = currentAmount.subtract(monthlyAmount);
        }
        if(hasResidue){
            BigDecimal payment = loan.getResiduePayment();
            BigDecimal principal = payment;
            Payment p = new Payment();
            p.setNr(i + 1);
            p.setBalance(currentAmount);
            p.setInterest(residueInterest);
            p.setPrincipal(principal);

            addPaymentWithCommission(loan, p, payment.add(residueInterest));

            payments.add(p);
            currentAmount = currentAmount.subtract(principal);

        }
        loan.setPayments(payments);
        loan.setEffectiveInterestRate(calculateEffectiveInterestRate(loan));
    }



}
