package jp.sourceforge.fosj.loan.export;


import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.content.FileProvider;
import android.view.View;
import android.view.ViewGroup;
import android.widget.*;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import jp.sourceforge.fosj.loan.R;
import jp.sourceforge.fosj.loan.StartActivity;
import jp.sourceforge.fosj.loan.ThemeResolver;
import jp.sourceforge.fosj.loan.model.Loan;

public class ExportDialog extends Dialog {


    public ExportDialog(Context context) {
        super(context);
    }

    public ExportDialog(Context context, int theme) {
        super(context, theme);
    }

    protected ExportDialog(Context context, boolean cancelable, OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.export_dialog);
        setTitle(R.string.exportToEmail);
        GridView gridView = (GridView) findViewById(R.id.exportGridView);
        findViewById(R.id.exportCloseButton).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        gridView.setAdapter(new BaseAdapter() {
            @Override
            public int getCount() {
                return 2;
            }

            @Override
            public Object getItem(int position) {
                return null;
            }

            @Override
            public long getItemId(int position) {
                return 0;
            }

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                ImageView imageView;
                if (convertView == null) {
                    imageView = new ImageView(getContext());
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    imageView.setPadding(8, 8, 8, 8);
                } else {
                    imageView = (ImageView) convertView;
                }

                switch (position) {
                    case 0:
                        imageView.setImageResource(R.drawable.txt );
                        break;
                    case 1:
                        imageView.setImageResource( R.drawable.html);
                        break;

                }


                return imageView;
            }
        });

        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            public void onItemClick(AdapterView<?> parent, View v, int position, long id) {
              try {
                Intent sendIntent = new Intent(Intent.ACTION_SEND);
                Uri uri  = null;
                switch (position) {
                  case 0:
                    uri = createTxtExport(StartActivity.loan);
                    break;
                  case 1:
                    uri = createHtmlExport(StartActivity.loan);
                    break;

                }
                sendIntent.setType("text/plain");
                sendIntent.putExtra(Intent.EXTRA_SUBJECT, getContext().getString(R.string.app_name));
                sendIntent.putExtra(Intent.EXTRA_TEXT, "File attached.");
                sendIntent.putExtra(Intent.EXTRA_STREAM, uri);
                getContext().startActivity(Intent.createChooser(sendIntent, "Select application"));
                dismiss();
              }
              catch (IOException e) {
                e.printStackTrace();
              }
            }


        });
    }

  private Uri createHtmlExport(Loan loan) throws IOException {
    FileOutputStream fos = null;
    try {
      String name = "loan_export.html";
//      fos = getContext().openFileOutput(name, Context.MODE_WORLD_READABLE);
      fos = getContext().openFileOutput(name, Context.MODE_PRIVATE);
      File file = new File(getContext().getFilesDir(), name);

      new HtmlExporter(loan , this.getContext()).write(fos);

      Uri uri = FileProvider.getUriForFile(getContext(),getContext().getPackageName() + ".provider", file);
//      return  Uri.fromFile(file);
      return  uri;
    }
    finally {
      if (fos != null) {
        fos.close();
      }
    }


  }

  private Uri createTxtExport(Loan loan) throws IOException{
      FileOutputStream fos = null;
     try {
       String name = "loan_export.txt";
//       fos = getContext().openFileOutput(name, Context.MODE_WORLD_READABLE);
       fos = getContext().openFileOutput(name, Context.MODE_PRIVATE);
       File file = new File(getContext().getFilesDir(), name);

       new TxtExporter(loan , this.getContext()).write(fos);

       Uri uri = FileProvider.getUriForFile(getContext(), getContext().getPackageName() + ".provider", file);
//      return  Uri.fromFile(file);
       return  uri;
     }
     finally {
       if (fos != null) {
         fos.close();
       }
     }
  }
}



