<?php
// $Id: xoops_version.php,v1.00 2012/01/21 02:32:00 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                        FormMakeX for XOOPS Cube                           //
//                   Copyright (c) 2005 - 2012 Bluemoon inc.                 //
//                       <http://www.bluemooninc.jp/>                        //
//              Original source by : phpESP V1.6.1 James Flemer              //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;
$mydirname = basename( dirname( __FILE__ ) ) ;
if( ! preg_match( '/^(\D+)(\d*)$/' , $mydirname , $regs ) ) echo ( "invalid dirname: " . htmlspecialchars( $mydirname ) ) ;
$mydirnumber = $regs[2] === '' ? '' : intval( $regs[2] ) ;
/**
 * Setup globals for later use
 */
Global $xoopsDB, $xoopsUser, $xoopsModule;
Global $xoopsModuleConfig;

$modversion['name'] = _MI_FORMMAKEX_NAME . $mydirnumber ;
$modversion['version'] = 1.01;
$modversion['description'] = _MI_FORMMAKEX_DESC;
$modversion['author'] = "Yoshi Sakai";
$modversion['credits'] = "Copright(c) Bluemoon inc. "
."Based By phpESP project";
$modversion['help'] = "formmakex.html";
$modversion['license'] = "GPL see LICENSE";
$modversion['official'] = 0;
$modversion['image'] = "images/formmakex{$mydirnumber}_slogo.gif";
$modversion['dirname'] = $mydirname;

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/formmakex{$mydirnumber}.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][0] = "formmakex{$mydirnumber}_realm";
$modversion['tables'][1] = "formmakex{$mydirnumber}_respondent";
$modversion['tables'][2] = "formmakex{$mydirnumber}_designer";
$modversion['tables'][3] = "formmakex{$mydirnumber}_form" ;
$modversion['tables'][4] = "formmakex{$mydirnumber}_question_type" ;
$modversion['tables'][5] = "formmakex{$mydirnumber}_question" ;
$modversion['tables'][6] = "formmakex{$mydirnumber}_question_choice" ;
$modversion['tables'][7] = "formmakex{$mydirnumber}_access" ;
$modversion['tables'][8] = "formmakex{$mydirnumber}_response" ;
$modversion['tables'][9] = "formmakex{$mydirnumber}_response_bool" ;
$modversion['tables'][10] = "formmakex{$mydirnumber}_response_single" ;
$modversion['tables'][11] = "formmakex{$mydirnumber}_response_multiple" ;
$modversion['tables'][12] = "formmakex{$mydirnumber}_response_rank" ;
$modversion['tables'][13] = "formmakex{$mydirnumber}_response_text" ;
$modversion['tables'][14] = "formmakex{$mydirnumber}_response_other" ;
$modversion['tables'][15] = "formmakex{$mydirnumber}_response_date" ;


// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";	//manage.php";
$modversion['adminmenu'] = "admin/menu.php";

// Menu
$modversion['hasMain'] = 1;
$modhandler = &xoops_gethandler('module');
$xoopsMSModule = &$modhandler->getByDirname($mydirname);
if (is_object($xoopsUser) && isset($xoopsModuleConfig['MANAGERS'])){
    if (is_object($xoopsMSModule) && $xoopsMSModule->getVar('isactive')){
        $groups = $xoopsUser->getGroups();
        if (array_intersect($xoopsModuleConfig['MANAGERS'], $groups)){
			$modversion['sub'][1]['name'] = _MI_FORMMAKEX_NEW;
			$modversion['sub'][1]['url'] = "manage.php?where=new";
        }
    }
}

// Templates
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_list.html'	,		'description' => 'List of Form');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_index.html'	,		'description' => 'index');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_controlpanel.html',	'description' => 'Control Panel');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_form.html',		'description' => 'Form Render');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_form_forms.html',	'description' => 'Form Form');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_pda.html',			'description' => '');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_design.html',		'description' => 'Form Design');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_manage.html',		'description' => 'Form Manager');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_general.html',		'description' => 'General');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_questions.html',		'description' => 'Questions');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_order.html',			'description' => 'Order');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_preview.html',		'description' => 'Preview');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_manage_results.html','description' => 'Results view');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_manage_results_chart.html','description' => 'Results view');
$modversion['templates'][] = array('file' => 'formmakex'.$mydirnumber.'_message.html'	,		'description' => 'message');

// Blocks
$modversion['blocks'][1]['file'] = "formmakex_top.php";
$modversion['blocks'][1]['name'] = _MI_FORMMAKEX_BNAME1.$mydirnumber;
$modversion['blocks'][1]['description'] = "FormMakeX" ;
$modversion['blocks'][1]['show_func'] = "b_formmakex_show";
$modversion['blocks'][1]['edit_func'] = "b_formmakex_edit";
$modversion['blocks'][1]['template'] = "formmakex".$mydirnumber."_block.html";
$modversion['blocks'][1]['can_clone'] = true ;
$modversion['blocks'][1]['options'] = "{$mydirname}|1";

// Comments
$modversion['hasComments'] = 0;

// Admin Preferences
// 2005/05/22 Add by Y.Sakai
$modversion['config'][] = array(
	'name'        => 'FILE_CHARSET',
	'title'       => '_MI_FORMMAKEX_FILECHARSET',
	'description' => '_MI_FORMMAKEX_FILECHARSET_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => 'EUC-JP'
);
$modversion['config'][] = array(
	'name'        => 'CSV_CHARSET',
	'title'       => '_MI_FORMMAKEX_CSVCHARSET',
	'description' => '_MI_FORMMAKEX_CSVCHARSET_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => 'SJIS'
);
$modversion['config'][] = array(
	'name'        => 'CSV_ADDNUMBER',
	'title'       => '_MI_FORMMAKEX_CSVADDNUM',
	'description' => '_MI_FORMMAKEX_CSVADDNUM_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => '(%u)'
);
$modversion['config'][] = array(
	'name'        => 'CSV_CHOICEOPT',
	'title'       => '_MI_FORMMAKEX_CHOICEOPT',
	'description' => '_MI_FORMMAKEX_CHOICEOPT_DESC',
	'formtype'    => 'select',
	'valuetype'   => 'int',
	'default'     => 0,
	'options'     => array('Strings' => 0,'Number' => 1)
);
$modversion['config'][] = array(
	'name'        => 'CSV_OTHERF',
	'title'       => '_MI_FORMMAKEX_CSVOTHERF',
	'description' => '_MI_FORMMAKEX_CSVOTHERF_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => 'Other(%s)'
);
$modversion['config'][] = array(
	'name'        => 'MAILSERVER',
	'title'       => '_MI_FORMMAKEX_MAILSERVER',
	'description' => '_MI_FORMMAKEX_MAILSERVER_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MAILUSER',
	'title'       => '_MI_FORMMAKEX_MAILUSER',
	'description' => '_MI_FORMMAKEX_MAILUSER_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MAILPWD',
	'title'       => '_MI_FORMMAKEX_MAILPWD',
	'description' => '_MI_FORMMAKEX_MAILPWD_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MAILADDR',
	'title'       => '_MI_FORMMAKEX_MAILADDR',
	'description' => '_MI_FORMMAKEX_MAILADDR_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'CAST_KEY',
	'title'       => '_MI_FORMMAKEX_CASTKEY',
	'description' => '_MI_FORMMAKEX_CASTKEY_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'MANAGERS',
	'title'       => '_MI_FORMMAKEX_MANAGEGROUP',
	'description' => '_MI_FORMMAKEX_MANAGEGROUP_DESC',
	'formtype'    => 'group_multi',
	'valuetype'   => 'array',
	'default'     => array(1)
);
$modversion['config'][] = array(
	'name'        => 'PSTATUS',
	'title'       => '_MI_FORMMAKEX_MGPSTATUS',
	'description' => '_MI_FORMMAKEX_MGPSTATUS_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 1
);
$modversion['config'][] = array(
	'name'        => 'BLOCKLIST',
	'title'       => '_MI_FORMMAKEX_BLOCKLIST',
	'description' => '_MI_FORMMAKEX_BLOCKLIST_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'int',
	'default'     => 10
);
$modversion['config'][] = array(
	'name'        => 'ADD_INFO',
	'title'       => '_MI_FORMMAKEX_ADDINFO',
	'description' => '_MI_FORMMAKEX_ADDINFO_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 0
);
$modversion['config'][] = array(
	'name'        => 'ADD_USAGE',
	'title'       => '_MI_FORMMAKEX_ADDUSAGE',
	'description' => '_MI_FORMMAKEX_ADDUSAGE_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 1
);
$modversion['config'][] = array(
	'name'        => 'ONE_RESPONSE',
	'title'       => '_MI_FORMMAKEX_ONERESPONSE',
	'description' => '_MI_FORMMAKEX_ONERESPONSE_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 0
);
$modversion['config'][] = array(
	'name'        => 'RESET_RB',
	'title'       => '_MI_FORMMAKEX_RESETRADIOBUTTON',
	'description' => '_MI_FORMMAKEX_RESETRADIOBUTTON_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 1
);
$modversion['config'][] = array(
	'name'        => 'RESULT_RANK',
	'title'       => '_MI_FORMMAKEX_RESULTRANK',
	'description' => '_MI_FORMMAKEX_RESULTRANK_DESC',
	'formtype'    => 'select',
	'valuetype'   => 'int',
	'default'     => 0,
	'options'     => array('Avarage' => 0,'Count' => 1)
);
$modversion['config'][] = array(
	'name'        => 'UNSET_GROUP',
	'title'       => '_MI_FORMMAKEX_UNSETGROUP',
	'description' => '_MI_FORMMAKEX_UNSETGROUP_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'INVALID_JUMPURI',
	'title'       => '_MI_FORMMAKEX_INVALIDJUMPURI',
	'description' => '_MI_FORMMAKEX_INVALIDJUMPURI_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'SUBMIT_JUMPURI',
	'title'       => '_MI_FORMMAKEX_SUBMITJUMPURI',
	'description' => '_MI_FORMMAKEX_SUBMITJUMPURI_DESC',
	'formtype'    => 'textbox',
	'valuetype'   => 'text',
	'default'     => null
);
$modversion['config'][] = array(
	'name'        => 'SHOW_PUBLIC_TO_OTHERGROUP',
	'title'       => '_MI_SHOW_PUBLIC_TO_OTHERGROUP',
	'description' => '_MI_SHOW_PUBLIC_TO_OTHERGROUP_DESC',
	'formtype'    => 'yesno',
	'valuetype'   => 'int',
	'default'     => 0
);

?>
