package jp.sourceforge.foolishmerge.merge;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * デルタのセットを保持するクラス。
 */
final class DeltaSet extends AbstractSet {

  /**
   * デルタのリスト
   */
  private List deltas = new ArrayList();

  /**
   * セット内の要素数を返す。
   * @return セット内の要素数
   */
  public int size() {
    // リストの要素数を返す。
    return deltas.size();
  }

  /**
   * コレクションの要素のイテレータを返す。
   * @return イテレータ
   */
  public Iterator iterator() {
    // リストのイテレータを返す。
    return deltas.iterator();
  }

  /**
   * 指定された要素がセット内になかった場合、セットに追加する。
   * @return セットが指定された要素を保持していなかった場合はtrue
   */
  public boolean add(Object obj) {
    // リストに要素が含まれていた場合は処理を抜ける。
    if (deltas.contains(obj)) {
      return false;
    }

    // リストに要素を追加する。
    return deltas.add(obj);
  }

}
