package jp.sourceforge.foolishmerge;

import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.PatchFailedException;

import jp.sourceforge.foolishmerge.merge.Merge;
import jp.sourceforge.foolishmerge.text.Modified;
import jp.sourceforge.foolishmerge.text.Original;

/**
 * 間抜けなマージクラス。
 */
public final class FoolishMerge {

  /**
   * 編集前のオリジナルのテキスト
   */
  private Original original = null;

  /**
   * 編集後のテキスト1
   */
  private Modified modified1 = null;

  /**
   * 編集後のテキスト2
   */
  private Modified modified2 = null;

  /**
   * オブジェクトを生成する。
   * @param org オリジナルのテキスト
   * @param mod1 編集されたテキスト1
   * @param mod2 編集されたテキスト2
   */
  public FoolishMerge(String org, String mod1, String mod2) {
    // オリジナルテキストを生成。
    original = new Original(org);

    // 編集後のテキストを生成。
    modified1 = new Modified(mod1);
    modified2 = new Modified(mod2);
  }

  /**
   * マージする。
   * @param filename コンフリクト時に表示するファイル名
   * @param revision コンフリクト時に表示するリビジョン
   * @return コンフリクトしなかった場合はtrue
   * @throws DifferentiationFailedException 差分の取得に失敗した場合
   * @throws PatchFailedException パッチに失敗した場合
   */
  public boolean merge(String filename, String revision)
    throws DifferentiationFailedException, PatchFailedException {

    // 編集後のテキストが等しい場合は処理を抜ける。
    if (modified1.equals(modified2)) {
      return true;
    }

    // テキストを比較する。
    boolean conflict =
      Merge.merge(original, modified1, modified2, filename, revision);

    // コンフリクトしたどうかを返す。
    return conflict;
  }

  /**
   * マージされたテキストを返す。
   * @return マージされたテキスト
   */
  public String getMerged() {
    // オリジナルのテキストから、マージされたテキストを取得。
    String merged = original.getMergerd();

    // マージされたテキストを返す。
    return merged;
  }

}
