package sample;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.PatchFailedException;

import jp.sourceforge.foolishmerge.FoolishMerge;

public class MergeSample {

  public static void main(String[] args) {
    try {
      log("[[[[[ SAMPLE1 ]]]]]\n");
      not_conflict();
      log("[[[[[ SAMPLE2 ]]]]]\n");
      conflict();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private static void not_conflict()
    throws DifferentiationFailedException, PatchFailedException {
    String org =
      "#include <stdio.h>\n"
        + "\n"
        + "main()\n"
        + "{\n"
        + "    printf(\"hello, world\\n\");\n"
        + "}\n";

    String rev1 =
      "#include <stdio.h>\n"
        + "#include <stdlib.h>\n"
        + "\n"
        + "main()\n"
        + "{\n"
        + "    int i;\n"
        + "    i = abs(-10);\n"
        + "    printf(\"hello, world\\n\");\n"
        + "    printf(\"i = %d\\n\", i);\n"
        + "}\n";

    String rev2 =
      "#include <stdio.h>\n"
        + "\n"
        + "main()\n"
        + "{\n"
        + "    printf(\"hello, world\\n\");\n"
        + "    printf(\"good by, world\\n\");\n"
        + "}\n";

    log("///// original /////");
    log(org + "\n");

    log("///// revision1 /////");
    log(rev1 + "\n");

    log("///// revidion2 /////");
    log(rev2 + "\n");

    FoolishMerge fmerge = new FoolishMerge(org, rev1, rev2);
    boolean result = fmerge.merge("hello.c", "1.3");

    log("///// merged (not confrict: " + result + ") /////");
    log(fmerge.getMerged() + "\n");
  }

  private static void conflict()
    throws DifferentiationFailedException, PatchFailedException {
    String org =
      "#include <stdio.h>\n"
        + "\n"
        + "main()\n"
        + "{\n"
        + "    printf(\"hello, world\\n\");\n"
        + "}\n";

    String rev1 =
      "#include <stdio.h>\n"
        + "\n"
        + "main()\n"
        + "{\n"
        + "    printf(\"good by, world\\n\");\n"
        + "}\n";

    String rev2 =
      "#include <stdio.h>\n"
        + "\n"
        + "main()\n"
        + "{\n"
        + "    printf(\"hello, FoolishMerge\\n\");\n"
        + "}\n";

    log("///// original /////");
    log(org + "\n");

    log("///// revision1 /////");
    log(rev1 + "\n");

    log("///// revidion2 /////");
    log(rev2 + "\n");

    FoolishMerge fmerge = new FoolishMerge(org, rev1, rev2);
    boolean result = fmerge.merge("hello.c", "1.3");

    log("///// merged (not confrict: " + result + ") /////");
    log(fmerge.getMerged() + "\n");
  }

  private static void log(Object msg) {
    System.out.println(msg);
  }

}
