/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.foolishmerge.merge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import jp.sourceforge.foolishmerge.merge.Conflict;
import jp.sourceforge.foolishmerge.merge.ConflictDeltas;
import jp.sourceforge.foolishmerge.text.Modified;
import jp.sourceforge.foolishmerge.text.Original;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.diff.Revision;

public final class Merge {
    public static boolean merge(Original original, Modified modified, Modified modified2, String string, String string2) throws DifferentiationFailedException, PatchFailedException {
        boolean bl = true;
        Revision revision = original.diff(modified);
        Revision revision2 = original.diff(modified2);
        ListIterator listIterator = Merge.iterator(revision);
        ListIterator listIterator2 = Merge.iterator(revision2);
        Delta delta = Merge.getDelta(listIterator);
        Delta delta2 = Merge.getDelta(listIterator2);
        while (delta != null || delta2 != null) {
            int n = Conflict.conflict(delta, delta2);
            switch (n) {
                case -2: {
                    original.patch(delta);
                    delta = Merge.getDelta(listIterator);
                    break;
                }
                case 2: {
                    original.patch(delta2);
                    delta2 = Merge.getDelta(listIterator2);
                    break;
                }
                default: {
                    bl = false;
                    ConflictDeltas conflictDeltas = new ConflictDeltas(listIterator, listIterator2);
                    conflictDeltas.loadDeltas(delta, delta2);
                    original.merge(conflictDeltas, string, string2);
                    delta = Merge.getDelta(listIterator);
                    delta2 = Merge.getDelta(listIterator2);
                }
            }
        }
        return bl;
    }

    private static ListIterator iterator(Revision revision) {
        Delta delta;
        ArrayList<Delta> arrayList = new ArrayList<Delta>();
        int n = 0;
        while (n < revision.size()) {
            delta = revision.getDelta(n);
            arrayList.add(delta);
            ++n;
        }
        delta = arrayList.listIterator();
        return delta;
    }

    private static Delta getDelta(Iterator iterator) {
        Delta delta = null;
        if (iterator.hasNext()) {
            delta = (Delta)iterator.next();
        }
        return delta;
    }
}

