/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.foolishmerge.merge;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import jp.sourceforge.foolishmerge.merge.Conflict;
import jp.sourceforge.foolishmerge.merge.DeltaSet;
import org.apache.commons.jrcs.diff.Delta;

public final class ConflictDeltas {
    private ListIterator dltsIte1 = null;
    private ListIterator dltsIte2 = null;
    private Set dlts1 = new DeltaSet();
    private Set dlts2 = new DeltaSet();
    private int first = 0;
    private boolean setFirst = false;
    private int last = 0;

    ConflictDeltas(ListIterator listIterator, ListIterator listIterator2) {
        this.dltsIte1 = listIterator;
        this.dltsIte2 = listIterator2;
    }

    void loadDeltas(Delta delta, Delta delta2) {
        if (delta == null || delta2 == null) {
            return;
        }
        int n = Conflict.conflict(delta, delta2);
        switch (n) {
            case -1: {
                this.dlts1.add(delta);
                this.dlts2.add(delta2);
                this.setFirst(delta);
                this.setLast(delta2);
                delta = ConflictDeltas.getDelta(this.dltsIte1);
                this.loadDeltas(delta, delta2);
                break;
            }
            case 1: {
                this.dlts1.add(delta);
                this.dlts2.add(delta2);
                this.setFirst(delta2);
                this.setLast(delta);
                delta2 = ConflictDeltas.getDelta(this.dltsIte2);
                this.loadDeltas(delta, delta2);
                break;
            }
            case 0: {
                this.dlts1.add(delta);
                this.dlts2.add(delta2);
                this.setFirst(delta, delta2);
                this.setLast(delta);
                break;
            }
            case 2: {
                this.dltsIte1.previous();
                break;
            }
            case -2: {
                this.dltsIte2.previous();
            }
        }
    }

    private static Delta getDelta(Iterator iterator) {
        Delta delta = null;
        if (iterator.hasNext()) {
            delta = (Delta)iterator.next();
        }
        return delta;
    }

    private void setFirst(Delta delta) {
        if (this.setFirst) {
            return;
        }
        this.first = delta.getOriginal().first();
        this.setFirst = true;
    }

    private void setFirst(Delta delta, Delta delta2) {
        int n;
        if (this.setFirst) {
            return;
        }
        int n2 = delta.getOriginal().first();
        this.first = n2 <= (n = delta2.getOriginal().first()) ? n2 : n;
        this.setFirst = true;
    }

    private void setLast(Delta delta) {
        this.last = delta.getOriginal().last();
    }

    public Set getDeltas1() {
        return this.dlts1;
    }

    public Set getDeltas2() {
        return this.dlts2;
    }

    public int first() {
        return this.first;
    }

    public int last() {
        return this.last;
    }
}

