
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>

#include <MMSYSTEM.H>
#include "mes.h"
#include "mciplay.h"

BOOL openS =FALSE;
BOOL openC =FALSE;
char name[] ="myplayer";


void MciEnd() 
{
	if(openS) mciSendString("close myplayer",NULL,0,NULL);
	openS =FALSE;
}


void MciOpen(char *file, HWND hwnd)
{
	char str[500];
	if(openS){
		MciEnd();
		openS =FALSE;
	}

	wsprintf(str,"open \"%s\" alias myplayer",file);
	if(mciSendString(str,NULL,0,NULL)==0)
		openS =TRUE;
}

void MciPlay() 
{
	mciSendString("play myplayer ",NULL,0,NULL);	
}


void MciStop() 
{
	mciSendString("stop myplayer",NULL,0,NULL);	
}

int MciStatus() 
{
	char buf[256];
	mciSendString("status myplayer mode",buf,sizeof(buf),NULL);	
	if (strcmp(buf ,"stopped")==0) return mci_stopped;	
	if (strcmp(buf ,"playing")==0) return mci_play;
	return mci_default;
}


// ---------------------
// mciSendCommand ver.

MCIDEVICEID id;
HWND hWnd;


void mciEnd() 
{
	if(openC) mciSendCommand( id,
		MCI_CLOSE,MCI_WAIT,(DWORD)NULL);
	
	openS =FALSE;
}

void mciOpen(char *file, HWND hwnd)
{
	hWnd =hwnd;
	if(openC){
		mciEnd();
		openC =FALSE;
	}
	MCI_OVLY_OPEN_PARMS stOpenParams;
	DWORD ret;

	stOpenParams.lpstrElementName=file; // t@C
	stOpenParams.hWndParent=hwnd; // eEBhẼnh
	stOpenParams.dwStyle=WS_CHILD|WS_BORDER;    // 쐬EBhẼ^Cv
	// I[v
	ret =mciSendCommand(0,
		MCI_OPEN,
		MCI_WAIT|MCI_OPEN_ELEMENT|MCI_ANIM_OPEN_PARENT|MCI_ANIM_OPEN_WS|MCI_NOTIFY	,
		(DWORD)(LPVOID)&stOpenParams);
	// foCXhc̎擾
	id =stOpenParams.wDeviceID;
	if(ret ==0) openC =TRUE;
}

void mciPlay()
{
	MCI_PLAY_PARMS strPlayParams;
	mciSendCommand( id,
		MCI_PLAY,MCI_NOTIFY,(DWORD)&hWnd);
}


void mciStop() 
{
	mciSendCommand( id,
		MCI_STOP,MCI_WAIT,(DWORD)NULL);
}


