
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <stdio.h>
#include <fstream.h>
#include <windows.h>
#include "win.h"
#include "mes.h"
#include "status.h"

#define CommandLen 1000
#define DllLen 100

typedef (WINAPI *zzz)(const HWND,LPCSTR ,LPSTR ,const DWORD);
zzz fn;
HINSTANCE hLib ;//= LoadLibrary( "zip32j.DLL");

BOOL zipflag;


void FreeDll()
{
	FreeLibrary(hLib);
	setstatus("free dll");
}

BOOL dllLoad(char *name, char *fncname)
{
//	static char currentdll[DllLen]="";
	zipflag =FALSE;
	hLib = LoadLibrary( name);
	//if (hLib) strcpy(currentdll, name);
	if (hLib) {
		fn =(zzz)GetProcAddress(hLib, fncname);
		if(fn == NULL) {
			setstatus(fncname ,"load error");
		}
		else {
			zipflag =TRUE;
			setstatus("loaded",fncname);
			return TRUE;
		}
	}
	
	FreeDll();
	return FALSE;
}



char buf[CommandLen];
char ans[CommandLen];

void DoZip(HWND hWnd, char *zip, char *from)
{
	if(!zipflag) 
	{
		setstatus("no-dll");
		return;
	}
	sprintf(buf, "-r \"%s.zip\" \"%s\"", zip, from);
	setstatus(buf);
	(*fn)(hWnd, buf, ans, CommandLen );
	LogWin(ans);
}

void DoLzh(HWND hWnd, char *zip, char *from, char *file)
{
	if(!zipflag) 
	{
		setstatus("no-dll");
		return;
	}
	//a ***.lzh -x1r2a2 path file
	//fBNgTufBNg܂߂ĂׂĊi[
	sprintf(buf, "a \"%s.lzh\" -x1r2a2 \"%s\\%s\"", zip, from, file);
	setstatus(buf);
	(*fn)(hWnd, buf, ans, CommandLen );
	LogWin(ans);
}

// e c:\arc\archive.lzh -x1a1 -c c:\ *.*
//  fBNg\č\zȂ c:\ ɓWJB
//

void DoUnLzh(HWND hWnd, char *to, char *from)
{
	if(!zipflag) 
	{
		setstatus("no-dll");
		return;
	}
	sprintf(buf, "e \"%s\" -x1a1 -c \"%s\\\" *.*", from, to);
	setstatus(buf);
	(*fn)(hWnd, buf, ans, CommandLen );
	LogWin(ans);
}