
//        filemv

#define _main
#include "defextern.h"


#ifndef STRICT
    #define STRICT
#endif
#include <stdio.h>
#include <fstream.h>
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
//#include "dir.h"
#include "resource.h"
#include "myfilemv.h"
#include "initial.h"
#include "file.h"
#include "batch.h"
#include "mode.h"
#include "edit.h"
#include "status.h"
#include "listview.h"
#include "keyboard.h"
#include "mainmsg.h"
#include "paintflag.h"
#include "zip.h"
#include "filecopy.h"
#include "spi.h"


#include "main.h"

HBRUSH hbrush;

#define windf(hW, x, y, wx, wy) DeferWindowPos(hDwp, hW, HWND_TOP, x, y, wx, wy, SWP_SHOWWINDOW)

BOOL MyFilter(HWND hWnd);
HWND MakeMyList(HWND hWnd,int id);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ListLProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ListRProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FileEditProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DirLEditProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DirREditProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DrvListProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK GetLenProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK GetNameProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyGetFNameProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyDriveProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyCreateDirProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyTextProc(HWND, UINT, WPARAM, LPARAM);
void setsel(HWND, char *);
void CompareList(HWND hList1, HWND hList2);
void SelectReverse(HWND hList);
void getlnkstr(char *f, char *buf);
BOOL MyZip(dirw &Fdir,dirw &Tdir,HWND hList);
BOOL MyLzh(dirw &Fdir,dirw &Tdir,HWND hList);
BOOL MyUnLzh(dirw &Fdir,dirw &Tdir,HWND hList);
WNDPROC OldDirLEdit;
WNDPROC OldDirREdit;
WNDPROC OldDrvList;
WNDPROC OldEdit;
WNDPROC OldListR;
WNDPROC OldListL;

char FilterAll[]= "*.*";
char FilterAuto[]= "*.tfa";
char Filter[MAX_FILTER]= "*";
char setname[MAX_PATH];

LPARAM sizelp;//OWM_SIZẼTCYf[^

DWORD dw;

char dragfile[MAX_PATH];
char picfile[MAX_PATH];
char commandline[MAX_PATH*3];
BOOL commandflag;
DWORD start,len;


char markon[]="<>";
char markoff[]="[]";

dirw *NDir;
dirw *NXDir;
dirw LDir(tab_l),RDir(tab_r);
int ind;
HWND NList,NXList;



class winp
{
	float prate;
	float rstep, ratemin, ratemax;
	BOOL rateflg;
	int ntab; //now tab
	int insideX,insideY;
	int pX,pY,pW,pH,memX,memY;
	int oX,oY;
	int listtop,listy,edittop,edity,buttonx,buttony, edit_w, listLy, listRy;
	int xLpercent,xRpercent,xL,xR,yL,yR,cx,cy;

    int dirL_h, dir_ueh, dir_sitah;
    int dirR_h, dir_h;
    int diredit_l, dir_w;
	HWND hList, hDirEdit, hListL, hDirEditL ,hUp ,hDown , hDir, hDirL,hEdit;
public:
	winp() {rateflg =FALSE;};
	void settab(int t) {ntab =t;}; 
	void setSizePara(LPARAM,int,BOOL ,int,int);
	void mvWins();
	void resetOrg() 
	{
		oX =0; oY =0; prate=1; rstep =0.1; 
		if(rateflg){ratemin=1;ratemax =2; };
	};
	int OrgX() {return oX;};
	int OrgY() {return oY;};
	float rate() {return prate;};
	void rate(float r) {prate=r;};
	void rateStop() {ratemax =1; ratemin =1;};
	void rateUp() {prate = min(ratemax, prate+rstep); update();};
	void rateDown() {prate = max(ratemin, prate-rstep); update(); };
	void rateReset() {prate =1; update(); };
	void mvOrg(int x, int y) {oX +=x; oY +=y; update();};
	void update() {if(picshowflg) InvalidateRect(hmainwnd,NULL,FALSE);};
	void set(HWND,HWND,HWND,HWND,HWND,HWND,HWND);
	void setlist(HWND lL,HWND lR) {hList =lR; hListL =lL;};
	void BitBlt(HDC hdc, HDC mem, int wx, int wy)
	{
		pX =0; pY =0;
		pW =wx; pH =wy;
		memX =0;//oX;
		memY =0;//oY;

		if(ntab ==tab_r || mode==W_MODE_EDITONLY) 
		{
			pX =diredit_l;
		}
		else 
		{
			pX =xL +buttonx/2;
		}
		::BitBlt(hdc, pX,pY,pW,pH, mem, memX, memY, SRCCOPY);
	}
};

winp win;

void winp::set(HWND dr,HWND dl,HWND der, HWND del, HWND u, HWND d, HWND ed)
{
	hDir =dr;
	hDirL =dl;
	hDirEdit =der;
	hDirEditL =del;
	hUp =u;
	hDown =d;
	hEdit =ed;
}

void winp::mvWins()
{
    HDWP hDwp;
    hDwp = BeginDeferWindowPos(9);
    hDwp = windf( hDirL, xL -dir_w, dir_ueh, dir_w, dirL_h );
    hDwp = windf( hDir, xL , dir_ueh, dir_w, dirR_h );
    hDwp = windf( hDirEditL, diredit_l, dir_ueh, xL -dir_w, dirL_h);
    hDwp = windf( hDirEdit, xL +dir_w, dir_ueh, xR -dir_w, dirR_h);
    hDwp = windf( hListL, diredit_l, listtop, xL -buttonx/2, listLy);
    hDwp = windf( hList, xL +buttonx/2, listtop, xR - buttonx/2, listRy );
    hDwp = windf( hUp, xL -buttonx/2, listtop +listy/2 -25, buttonx, buttony);
    hDwp = windf( hDown, xL -buttonx/2, listtop +listy/2 +15, buttonx, buttony);
    hDwp = windf( hEdit, diredit_l, edittop, edit_w, edity);
    EndDeferWindowPos( hDwp );
}

void winp::setSizePara(LPARAM lp, int nStatus_h, BOOL picflg, int tab, int ListLWidth)
{
	sizelp=lp;
	dir_h = 30;
	dir_ueh = 0;//5;//dir ̏
	dir_sitah = 0;//5;
	diredit_l =0;
	dir_w =15;
	insideY =LOWORD(lp);
	edit_w =insideY; 
	insideX =HIWORD(lp) - nStatus_h;//
	listy =insideX -dir_h -dir_ueh -dir_sitah;
	if(mode==W_MODE_EDIT) 
	{
		listy /=2;
		listy =max(listy, 100);
	}
	if(mode==W_MODE_EDITONLY) 
	{
		listy =0;
		buttonx=0;
		buttony=0;
		dir_h =0;
	}
	else
	{
		buttonx=22;
		buttony=24;
	}
	if(ButtonMode==B_HIDE) { buttonx =0; dir_w =0;}
	if(mode==W_MODE_LIST) ;
	dirR_h =dir_h;
	dirL_h =dir_h;
	listtop =dir_h +dir_ueh +dir_sitah;
	edittop =listtop +listy;
	edity =insideX -listy -listtop;
	xLpercent =ListLWidth;
	xRpercent =100 -xLpercent;
	xL =(float)insideY /100 *xLpercent;
	xR =insideY -xL;
	listLy =listy;
	listRy =listy;
	if(picflg) 
	{
		ntab =tab;
		if(tab ==tab_r) {listLy =0; dirL_h =0;}
		if(tab ==tab_l) {listRy =0; dirR_h =0;}
		edity =0;
	}
}


dirw *GetNDir()
{
	return NDir;
}

dirw *GetNXDir()
{
	return NXDir;
}

dirw *GetLDir()
{
	return &LDir;
}

dirw *GetRDir()
{
	return &RDir;
}

char *GetLPath()
{
	return LDir.cd();
}

char *GetRPath()
{
	return RDir.cd();
}

char *GetNXPath()
{
	return NDir->cd();
}

struct iset{
	int from;
	int to;
} ;

int WINAPI WinMain(HINSTANCE hCurInst, HINSTANCE hPrevInst,
                   LPSTR lpsCmdLine, int nCmdShow)
{
    MSG msg;
	HACCEL hAccel;

    if (!InitApp(hCurInst))
        return FALSE;
	wsprintf(commandline,"%s",lpsCmdLine);

    if (!InitInstance(hCurInst, nCmdShow)) 
        return FALSE;
	

	hAccel = LoadAccelerators (hCurInst, "ACCEL") ;
    while (GetMessage(&msg, NULL, 0, 0)) {
		if (!TranslateAccelerator (hmainwnd, hAccel, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
    }
/*
    if (!InitApp(hCurInst))
        return FALSE;
    if (!InitInstance(hCurInst, nCmdShow)) 
        return FALSE;
    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }*/
    return msg.wParam;
}

//EBhEENX̓o^

ATOM InitApp(HINSTANCE hInst)
{
    WNDCLASSEX wc;
    wc.cbSize = sizeof(WNDCLASSEX);
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WndProc;    //vV[W
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;//CX^X
    wc.hIcon = LoadIcon(hInst, "APICON");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = "MYMENU";    //j[
    wc.lpszClassName = (LPCSTR)szClassName;
    wc.hIconSm = LoadIcon(hInst, "APICON");
    return (RegisterClassEx(&wc));
}


#define WS_ME (WS_OVERLAPPED     | \
                             WS_SYSMENU        | \
                             WS_THICKFRAME     | \
                             WS_MINIMIZEBOX    | \
                             WS_MAXIMIZEBOX)

//EBhE̐

BOOL InitInstance(HINSTANCE hInst, int nCmdShow)
{

    hmainwnd = CreateWindow(szClassName,
            appname, //^Cgo[ɂ̖O\܂
            WS_OVERLAPPEDWINDOW, //EBhE̎
            CW_USEDEFAULT,    //wW
            CW_USEDEFAULT,    //xW
            CW_USEDEFAULT,    //
            CW_USEDEFAULT,    //
            NULL, //eEBhẼnhAeƂNULL
            NULL, //j[nhANXj[gƂNULL
            hInst, //CX^Xnh
            NULL);
    if (!hmainwnd)
        return FALSE;
    ShowWindow(hmainwnd, nCmdShow);
    UpdateWindow(hmainwnd);
	::hInst=hInst;
    return TRUE;
}



void menusetting(HWND hwnd)
{
	hMenu =GetMenu(hwnd);
	hMainMenu =GetMenu(hwnd);
	hLeftMenu =GetSubMenu(hMenu, 1);
	hRMenu =GetSubMenu(hMenu, 3);
	hEditMenu =GetSubMenu(hMenu, 3);
	hRemoteMenu =GetSubMenu(hMenu, 4);
	hBothMenu =GetSubMenu(hMenu, 6);
	hSendtoMenu =GetSubMenu(hLeftMenu, 0);
	hSessionMenu =GetSubMenu(hMenu, 1);
	hFindMenu =GetSubMenu(hMenu, 2);
	hPopDefMenu =hLeftMenu;
	for (int n=0; n<TOPMENUNUM; n++) hSubPop[n] =GetSubMenu(hMenu, n);
}

HBRUSH setBrush()
{
	DeleteObject(hbrush);
	return CreateSolidBrush(listtextBkColor);
}

HBRUSH initBrush()
{
	return CreateSolidBrush(GRAY_BRUSH);
}

void EditMenuInit()
{
	UINT flag = geteditflag() ? MF_ENABLED : MF_GRAYED ;
	EnableMenuItem( hEditMenu, GetMenuItemID(hEditMenu,0), flag );
}

void FncCommandline(char* commandline,char* pathname)
{	
	int i=0;

	/*
	if(commandline[i]=='/')
	{
		i++;
		if(commandline[i]=='p'||commandline[i]=='P')
		{
			i++;
		}
	}
	*/
	while(commandline[i]==' '||commandline[i]=='\t')i++;

	for(int j=0;i<strlen(commandline);i++)
	  if(commandline[i]!='\"')
				 {
					  pathname[j]=commandline[i];
					  j++;
				 }
}

BOOL GetStrDlg(char *title, char *buf)
{
	strcpy(buf, title);
	if( DialogBoxParam(hInst, "MYCREATEDIR", hmainwnd,
		(DLGPROC)MyCreateDirProc, (LPARAM) buf)
		== IDCANCEL)
		return FALSE;
	else
		return TRUE;
}


void Mes(char *m)
{
	MessageBox(NULL, m, "E", MB_OK);
}
void Mes(int i)
{
	char *buffer=commandline;
	wsprintf(buffer,"%d",i);
	MessageBox(NULL, buffer, "E", MB_OK);
}

LRESULT CALLBACK FileEditProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	DWORD key;
	if(msg == WM_KEYDOWN )
	{
		key =keyfnc(wp);
		if( wp == VK_ESCAPE )
		{
			SetFocus(hMainWnd);
			return 0;
		}
		if( key == 'W' +kCONTROL ) 
		{
			msgWinmode();
			return 0;
		}
	}
	return CallWindowProc(OldEdit, hWnd, msg, wp, lp);
}


void resettxt()
{
	NDir->resetEditText();
	NXDir->resetEditText();
}

LRESULT CALLBACK DEditProc(WNDPROC oldproc, int id, dirw &dir, HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	RECT rect;
	PAINTSTRUCT ps;
	HDC hdc;
	char buffer[MAX_PATH];
	char written[MAX_PATH];
	char bufferB[MAX_PATH];
	if(msg == WM_PAINT) {
		GetClientRect (hWnd, &rect) ;
		hdc =BeginPaint(hWnd, &ps);
			SetBkMode(hdc, OPAQUE);
		SelectObject( hdc, hbrush ) ;
		if(paintf) Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
		EndPaint(hWnd,&ps);
		InvalidateRect(hWnd,&rect,FALSE);
	}
	if(msg == WM_KILLFOCUS)
	{
		resettxt();
	}
	if(msg == WM_KEYDOWN)
	{
		if( wp == VK_ESCAPE )
		{
			SetFocus(hMainWnd);
			return 0;
		}
		if( wp == VK_RETURN )
			SendMessage(hMainWnd, WM_COMMAND, MAKELONG( id, BN_CLICKED ), 0);
		if( wp == VK_TAB )
		{
			GetWindowText(hWnd, written, BUFFER_LEN);
			sprintf(buffer, "%s", dir.cd());
			if( getnextpath(id, buffer, written) ==_DIR )
				SetWindowText(hWnd, buffer);
			else 
			{
				SetWindowText(hWnd, dir.cd());
			}
			return 0;
		}
	}
	return CallWindowProc( oldproc, hWnd, msg, wp, lp);
}

LRESULT CALLBACK DirLEditProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	return DEditProc( OldDirLEdit, ID_DIRL, LDir, hWnd, msg, wp, lp);
}


LRESULT CALLBACK DirREditProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	return DEditProc( OldDirREdit, ID_DIR, RDir, hWnd, msg, wp, lp);
}


LRESULT CALLBACK ListProc(WNDPROC oldproc, HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	RECT rect;
	PAINTSTRUCT ps;
	HDC hdc;
	if(msg == WM_MOUSEMOVE )
	{
		if(mousemv) SetFocus(hWnd);
		return 0;
	}
	if(msg == WM_ERASEBKGND )
	{
		return 0;
	}
	if(msg == WM_PAINT) {
		GetClientRect (hWnd, &rect) ;
		hdc =BeginPaint(hWnd, &ps);
			SetBkMode(hdc, OPAQUE);
		SelectObject( hdc, hbrush ) ;
		if(paintf) Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
		EndPaint(hWnd,&ps);
		InvalidateRect(hWnd,&rect,FALSE);
	}
	return CallWindowProc( oldproc, hWnd, msg, wp, lp);
}

LRESULT CALLBACK ListRProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	return ListProc( OldListR, hWnd, msg, wp, lp );
}


LRESULT CALLBACK ListLProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	return ListProc( OldListL, hWnd, msg, wp, lp );
}


LRESULT CALLBACK DrvListProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	static HWND hParent;
	switch(msg)
	{
	case WM_KEYDOWN :
		if ( wp == VK_RETURN ) SendMessage(hParent, WM_COMMAND, MAKELONG( IDOK ,0 ), 0);
		break;
	case WM_LBUTTONDBLCLK :
		hParent = GetParent(hWnd);
		SendMessage(hParent, WM_COMMAND, MAKELONG( IDOK ,0 ), 0);
		break;
	default :
		break;
	}
	return CallWindowProc(OldDrvList, hWnd, msg, wp, lp);
}

COLORREF getItemTextColor(HWND list, int id, COLORREF def)
{
	ListView_GetItemText(list, id, pos.ext, buffer, ListItemLen);
	if(strcmp(buffer,extpaint) == 0) return listtextSpColor;
	else if( ! paintf ) return def;
	else return listtextColor;
}


LRESULT CALLBACK colorchange(HWND list, LPNMHDR lpnmhdr, HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
        LPNMLVCUSTOMDRAW lplvcd = (LPNMLVCUSTOMDRAW) lpnmhdr;
		int id;
		COLORREF clr;

        switch ( lplvcd->nmcd.dwDrawStage ) {
        case CDDS_PREPAINT:
            return CDRF_NOTIFYITEMDRAW;
        case CDDS_ITEMPREPAINT:
			id = lplvcd->nmcd.dwItemSpec;
			clr = getItemTextColor(list, id, lplvcd->clrText);
	        lplvcd->clrText = clr;
	        //lplvcd->clrTextBk = listtextBkColor;
            return CDRF_NEWFONT;
        }
    return FORWARD_WM_NOTIFY (hWnd, msg, lpnmhdr, DefWindowProc );
}


LRESULT CALLBACK ListNotify(int tab, dirw *NDir, char *szDir, char *szBuf, int iIndex, HWND hWnd, WPARAM wp, LPARAM lp)
{
	static LPNMHDR lpnmhdr;
    static int sortsubno[NO_OF_SUBITEM] = {UP};
    static int isortsubno=2;//ǂ̃TuACeŃ\[gĂ邩
    SORTDATA SortData;
    NMLISTVIEW *pNMLV;
	lpnmhdr = (LPNMHDR)lp;
	switch (lpnmhdr->code) {
		case NM_DBLCLK:
			hLastList = lpnmhdr->hwndFrom;
			if (strncmp(szBuf, isdirectory,5) != 0) {
				NDir->cd(".");
				if(checkbatch(szDir)) 
				{
					commandflag=TRUE;
					SendMessage(hWnd,WM_DROPFILES,0,0);
				}
				else if(checkExt(szDir,"lnk"))
				{
					getlnkstr(szDir,commandline);
					NDir->cd(commandline);
					reloadtab();
				}
				else ShellExecute(NULL, "",szDir, "", NULL, SW_SHOW);
				break;
			}
			NDir->cd(szDir);
			reloadtab();
			break;
		case NM_CLICK:
			hLastList = lpnmhdr->hwndFrom;
			break;
		case LVN_KEYDOWN:
			ListKeyFunc(hWnd,WM_NOTIFY,wp,lp,tab);
			break;
		case LVN_ITEMCHANGED://NM_CLICK:
			hLastList = lpnmhdr->hwndFrom;
			//editmode();
			if ( mode != W_MODE_LIST && strncmp(szBuf, isdirectory,5) != 0)
			{
				if(autoedit)autooverwrite(hEdit);
				seteditflag(TRUE);
				setfile(hEdit,szDir,NDir->cd());
			}
			else
			{
				seteditflag(FALSE);
				SetWindowText(hEdit,"");
			}
			setstatusspace(iIndex+1,NDir->GetItemNum(),NDir->GetSpace(),NDir->GetTotal());
			setstatusonly(szDir);
			if(picshowflg) {
				win.resetOrg();
				InvalidateRect(hmainwnd,NULL,FALSE);
			}
			resize();
			break;
		case LVN_COLUMNCLICK:
			pNMLV = (NMLISTVIEW *)lp;
			isortsubno = pNMLV->iSubItem;
			if (sortsubno[isortsubno] == UP)
				sortsubno[isortsubno] = DOWN;
			else
				sortsubno[isortsubno] = UP;
			SortData.hwndList = NDir->getList();
			SortData.isortSubItem = isortsubno;
			SortData.iUPDOWN = sortsubno[isortsubno];
			if(ListView_SortItems(NDir->getList(), MyCompProc, &SortData) != TRUE)
				setstatusonly("\[gs");
			break;
		case NM_CUSTOMDRAW:
			return colorchange(((LPNMHDR)lp)->hwndFrom, lpnmhdr, hWnd, WM_NOTIFY, wp, lp);
		default:
			return 0;//DefWindowProc(hWnd, WM_NOTIFY, wp, lp);
	}
	return 0;
}

void setCTab(int tab)
{
	if(tab==tab_l){
		NDir =&LDir;
		NXDir =&RDir;
		NList =hListL;
		NXList =hList;
	}
	if(tab==tab_r){
		NDir =&RDir;
		NXDir =&LDir;
		NList =hList;
		NXList =hListL;
	}
}


void setfilter(char *str =Filter)
{
	sprintf(Filter,"%s", str);
	savefilter(str);
	filefilter =Filter;
}

void getlnkstr(char *f, char *buf)
{
	char buff[2000];
	char *p;
	ifstream in(f,ios::binary);

	int i=0;
	while(i<2000)
	{
		if(!in) in.clear();
		in.seekg(i,ios::beg);
		in.read(buff,2000);
		//p=strrchr(buff,':');
		if(buff[0]=='D') {strcpy(buf,buff);}
		i++;
	}
}


void redraw(HWND hwnd,HDC hdc)
{
	RECT rect;
	GetClientRect (hwnd, &rect) ;
	//InvalidateRect(hwndEdit,NULL,TRUE);
}

void setselbuf(int iIndex, char *szDir, char *szBuf, HWND NList)
{
	szBuf[0]=0;
    ListView_GetItemText(NList, iIndex, pos.name, szDir, MAX_PATH);
    ListView_GetItemText(NList, iIndex, pos.size, szBuf, MAX_PATH);
}

void setlistbuffers(int tab, int iIndex, char *szDir, char *szBuf, HWND NList, char *file)
{
	setCTab(tab);
    iIndex = ListView_GetNextItem(NList, -1, LVNI_SELECTED);
    //iIndex = ListView_GetHotItem(NList);
	setselbuf(iIndex, szDir, szBuf, NList);
	strcpy(file,szDir);
	bmpflg =checkExt(file, "bmp");
	jpgflg =checkExt(file, "jpg");
	picshowflg =(bmpflg || jpgflg);
	if(picshowflg) sprintf(picfile,"%s\\%s",NDir->cd(),file);
}

int fnc()
{
	static int it=0;
	it+=3;
	return it;
}

BOOL isnotDir(char *dir)
{
	if(strlen(dir)<5) return FALSE;
	if( strncmp(dir,"http",4) ==0 ) return TRUE;
	if( strchr(dir,'\%') !=NULL ) return TRUE;
	if( strncmp(dir,"ftp",3) ==0 ) return TRUE;
	if( strchr(dir,'\\')==NULL && strchr(dir,':')==NULL ) return TRUE;
	return FALSE;
}

void reloadClick(HWND hDirEdit, char *szDir, dirw &Dir, int tab)
{
	GetWindowText(hDirEdit,szDir,MAX_PATH);
	strcpy(commandline, szDir);
	if(isnotDir(commandline) ) 
	{
		if( MessageBox(hDirEdit,"s܂H",cmdDirect( "", Dir.cd(), commandline), MB_OKCANCEL)==IDOK )
			myexec( cmdDirect( "", Dir.cd(), commandline) );
	}
	else {
		Dir.cd(szDir);
		reloadtab(tab);
	}
}


HDC mem=NULL; 
HDC bmpmem=NULL;
HLOCAL hBInfo= NULL; 
HLOCAL hBm= NULL; 
HBITMAP hBitmap=NULL;
HBITMAP hBitmapOrg;

char lastPicFile[MAX_PATH]="";


void readpic(HDC &hdc, HDC &mem, int x, int y, float picrate, char *picfile)
{
	if ( ! spiLoad("jpg") ) return;

	int scX,scY;
	int topX,topY;
	BYTE *pBm;
	BITMAPINFO *pBInfo;
	BITMAPINFO BInfo;

	scX=GetSystemMetrics(SM_CXFULLSCREEN);
	scY=GetSystemMetrics(SM_CYFULLSCREEN);
	loadbmp(picfile,hBInfo,hBm);
	pBInfo = (BITMAPINFO*)LocalLock(hBInfo);
	topX =pBInfo->bmiHeader.biWidth;
	topY =pBInfo->bmiHeader.biHeight;
	int btmy =max(0,topY -scY);
	int FrX =(scX +x)/picrate;
	int ToX =scX;
	int FrY =(scY +btmy +y)/picrate;
	int ToY =scY +btmy;
	if( hBitmap ==NULL ) hBitmap = CreateCompatibleBitmap(hdc,scX,scY);
	SelectObject(mem,hBitmap);
	pBm = (BYTE*)LocalLock(hBm);
	DWORD size =pBInfo->bmiHeader.biSizeImage;
	StretchDIBits(
            mem,
            0,
            0,
            ToX,
			ToY,
            x /picrate,
            y /picrate,
            FrX,
			FrY,
            pBm,
            pBInfo,
            DIB_RGB_COLORS,
            SRCCOPY);
		
        LocalUnlock(hBInfo);
        LocalUnlock(hBm);
		FreeSpi();
}


void memmap(BOOL end=TRUE, int x=0, int y=0, float picrate=0)
{
	char *pdata;
	if(picrate<1) picrate =1; //k͂ꂢłȂ̂ŕۗ
	static BITMAP bmp;
	HDC hdc;
	if(end) 
	{
		if(mem!=NULL)
		{
			//
			//DeleteDC(bmpmem); 
			DeleteObject(hBm);
			DeleteObject(hBitmap); 
			//DeleteObject(hBitmapOrg); 
			DeleteDC(mem); 
			mem =NULL;
			hBitmap =NULL;
		}
		return ;
	}
	else
	{
		if(mem==NULL)
		{
			hdc =GetDC(hmainwnd);
			mem = CreateCompatibleDC(hdc);
		}
	}
	//if( strcmp(picfile, lastPicFile) == 0) return;
	strcpy(lastPicFile, picfile);
 
	if(bmpflg)
	{
		hBm = (HBITMAP) LoadImage(hInst, picfile, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
		GetObject(hBm, sizeof(BITMAP), &bmp); 
		SelectObject(mem, hBm); 
	}
	if(jpgflg) 
	{
		readpic( hdc, mem, x, y, picrate, picfile);
	}
	ReleaseDC(hmainwnd ,hdc);
	return ;

}

void memmapReset()
{
	memmap();
}


LRESULT CALLBACK bmppaint(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp, char *file)
{
	 HDC hdc;
	 HBITMAP hBitmap;
	 BITMAP *bmp;
	 PAINTSTRUCT ps; 
	 RECT rect;

	if (bmpflg || jpgflg) 
	{
		hdc = BeginPaint(hWnd, &ps);
		GetWindowRect(hWnd, &rect);
		memmap(FALSE, win.OrgX(), win.OrgY(), win.rate());
		if(paintf) Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
		win.BitBlt(hdc, mem, rect.right -rect.left, rect.bottom -rect.top);
		EndPaint(hWnd, &ps); 
		return 0;
	} 
	else 
	{ 
		return (DefWindowProc(hWnd, msg, wp, lp)); 
	}
}


//EBhEvV[W

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
    static int id, iIndex, tab;
	MENUITEMINFO minfo;
    static HINSTANCE hInst;
    RECT rc;
	static RECT Max, Ini, Last;
	PAINTSTRUCT ps;
	char ext[ListItemLen];
    static char szDir[ListItemLen], szBuf[ListItemLen], file[ListItemLen];
    INITCOMMONCONTROLSEX icc;
    static LPNMHDR lpnmhdr;
    static LV_KEYDOWN *lvkeydown;
    static int sortsubno[NO_OF_SUBITEM] = {UP};
    NMLISTVIEW *pNMLV;
    SORTDATA SortData;
	static HDC hdc;
    static int isortsubno=2;//ǂ̃TuACeŃ\[gĂ邩
    int sb_size[] = {150, 200, -1};
    static int nStatus_h;//Xe[^Xo[̍
    POINT pt;
	POINT pDrop;
    static WINPOS winpos = {20, 20, 600, 450};//eEBhËʒuA傫
    static HIMAGELIST hImage;
	static int ListLWidth;
	RECT rect;
    
    switch (msg) {
        case WM_CREATE:
			ListLWidth=50;
			PopFileInitialize (hWnd);
			bmpflg =FALSE;
			jpgflg =FALSE;
			picshowflg =FALSE;
			initmode();
			initlistcolor();
			filefilter=FilterAll;
			ascii=TRUE;
			st.init();
			hbrush =initBrush();//listtextbkcolor);
			hMainWnd=hWnd;
			initsessionnum();
			menusetting(hWnd);
            MyGetInitialData(&winpos);//
			if(wide) widemode();
			EditMenuInit();
			initlog(log);
			settitle(hWnd);
            if(winpos.wx>0) MoveWindow(hWnd, winpos.x, winpos.y, winpos.wx, winpos.wy, TRUE);
            icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
            icc.dwICC = ICC_LISTVIEW_CLASSES | ICC_BAR_CLASSES;
            InitCommonControlsEx(&icc);
            hInst = ((LPCREATESTRUCT)lp)->hInstance;
            GetClientRect(hWnd, &rc);
            hList = MakeMyList(hWnd, ID_LIST);
            InsertMyColumn(hList);
            hListL = MakeMyList(hWnd, ID_LISTL);
			win.setlist( hListL, hList );

            InsertMyColumn(hListL);
			hDir = CreateWindowEx ( 0, 
				TEXT("button"), "",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_DIR, hInst, NULL) ;
			hDirL = CreateWindowEx ( 0, 
				TEXT("button"), "",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_DIRL, hInst, NULL) ;
			hUp = CreateWindowEx ( 0, 
				TEXT("button"), ">",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_UP, hInst, NULL) ;
			hDown = CreateWindowEx ( 0, 
				TEXT("button"), "<",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_DOWN, hInst, NULL) ;
            hDirEdit = CreateWindowEx(0,
                "edit", "",
                WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER,
                0, 0, 0, 0,    hWnd, (HMENU)ID_STATIC, hInst, NULL);
            hDirEditL = CreateWindowEx(0,
                "edit", "",
                WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER,
                0, 0, 0, 0,    hWnd, (HMENU)ID_STATICL, hInst, NULL);
            hEdit = CreateWindowEx(0,
                "edit", "",
				WS_CHILD | WS_VISIBLE | ES_MULTILINE | ES_WANTRETURN |
                WS_VSCROLL | WS_HSCROLL | ES_AUTOVSCROLL | ES_AUTOHSCROLL,
                //WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER | ES_MULTILINE ,
                0, 0, 0, 0,    hWnd, (HMENU)ID_EDIT, hInst, NULL);

			win.set(hDir,hDirL,hDirEdit,hDirEditL,hUp,hDown,hEdit);

			OldDirLEdit =(WNDPROC) SetWindowLong (hDirEditL, GWL_WNDPROC, (LPARAM) DirLEditProc);
			OldDirREdit =(WNDPROC) SetWindowLong (hDirEdit, GWL_WNDPROC, (LPARAM) DirREditProc);
			OldListL =(WNDPROC) SetWindowLong (hListL, GWL_WNDPROC, (LPARAM) ListLProc);
			OldListR =(WNDPROC) SetWindowLong (hList, GWL_WNDPROC, (LPARAM) ListRProc);
			OldEdit =(WNDPROC) SetWindowLong (hEdit, GWL_WNDPROC, (LPARAM) FileEditProc);
			LDir.cd( loadlastdir(1) );
			LDir.SetHandle(hListL,hDirEditL,hImage);
            LDir.SetItemNum( SetMyLocalDir(hWnd, LDir, hDirEditL, hImage) );
			RDir.cd( loadlastdir(2) );
			RDir.SetHandle(hList,hDirEdit,hImage);
            RDir.SetItemNum( SetMyLocalDir(hWnd, RDir, hDirEdit, hImage) );
			/*
            SortData.hwndList = hListL;
            SortData.isortSubItem = isortsubno;
            SortData.iUPDOWN = sortsubno[isortsubno];
            ListView_SortItems(hListL, MyCompProc, &SortData);*/
            hStatus = CreateStatusWindow(WS_CHILD | WS_VISIBLE, "", hWnd, ID_STATUSBAR);
            SendMessage(hStatus, SB_SETPARTS, (WPARAM)3, (LPARAM)sb_size);
            GetWindowRect(hStatus, &rc);
            nStatus_h = rc.bottom - rc.top;
			GetWindowRect(GetDesktopWindow(), &Max);
            hImage = ImageList_Create(16, 16, ILC_COLOR4, 2, 0);
			if(iconf){
				ListView_SetImageList(hListL, hImage, LVSIL_SMALL);
				ListView_SetImageList(hList, hImage, LVSIL_SMALL);
				ImageList_AddIcon(hImage, LoadIcon(hInst, "MYFILE"));
				ImageList_AddIcon(hImage, LoadIcon(hInst, "MYFILE"));
				ImageList_AddIcon(hImage, LoadIcon(hInst, "MYFOLDER"));
				ImageList_AddIcon(hImage, LoadIcon(hInst, "MYDRIVE"));
			}

			DragAcceptFiles(hWnd,TRUE);
			commandflag=FALSE;
		  if(strlen(commandline)>0)
		  {
				commandflag=TRUE;
				memset(file,0,MAX_PATH);
				FncCommandline(commandline,file);
				SendMessage(hWnd,WM_DROPFILES,0,0);
		  }
		  SetFocus(hListL);
		  if(!showmenu) SetMenu(hWnd,NULL);
		  //dllLoad();
            break;
        case WM_SIZE:
			if(lp ==0) lp =sizelp;
			win.setSizePara(lp, nStatus_h,picshowflg,tab, ListLWidth);
			win.mvWins();

            SendMessage(hStatus, WM_SIZE, wp, lp);
		
            break;
		case WM_DROPFILES:
			if(!commandflag) DragQueryFile((HDROP)wp,0,file,MAX_PATH); 
			DragQueryPoint((HDROP) wp, &pDrop);
			if(pDrop.x <HIWORD(sizelp)/2)
			{
				LDir.cd(file);
				reloadlocal();
			}
			else 
			{
				RDir.cd(file);
				reloadremote();
			}

			//Mes(file);
			//setfile(hEdit,file,NDir->cd(file));
			
			SetWindowText(hDirEditL,file);
			setstatus(file);
			break;
        case WM_CONTEXTMENU:
			hPopMenu =hPopDefMenu;
			if( keyfnc(0)==kSHIFT ) hPopMenu = hFindMenu;
			if( keyfnc(0)==kALT ) hPopMenu = hSubPop[1];
			if( keyfnc(0)==kCONTROL ) hPopMenu = hSubPop[2];
			if( keyfnc(0)==kCONTROL +kSHIFT) hPopMenu = hSubPop[5];
			if( keyfnc(0)==kALT +kSHIFT) hPopMenu = hSubPop[6];
			if( keyfnc(0)==kCONTROL +kALT) hPopMenu = hSubPop[7];
			if( keyfnc(0)==kCONTROL +kALT +kSHIFT) hPopMenu = hSubPop[0];
            pt.x = LOWORD(lp);
            pt.y = HIWORD(lp);
			pt.y=100;
            if (wp == (WPARAM)hListL) {
				tab =tab_l;
				setCTab(tab);
				NDir->setfile(szDir);
				TrackPopupMenu(hPopMenu, TPM_LEFTALIGN | TPM_TOPALIGN,
                    pt.x, pt.y, 0, hWnd, NULL);
            }
            if (wp == (WPARAM)hList) {
				tab =tab_r;
				setCTab(tab);
				TrackPopupMenu(hPopMenu, TPM_LEFTALIGN | TPM_TOPALIGN,
                    pt.x, pt.y, 0, hWnd, NULL);
            }
            
            break;
        case WM_NOTIFY:
            lpnmhdr = (LPNMHDR)lp;
			lvkeydown =(LV_KEYDOWN*)lp;//EN_UPDATE
			//Ђ
            if (lpnmhdr->hwndFrom == hListL) {
				tab =tab_l;
				iIndex =lpnmhdr->idFrom;
				setlistbuffers(tab, iIndex, szDir, szBuf, NList, file);
				return ListNotify(tab, NDir, szDir, szBuf, iIndex, hWnd, wp, lp);
            }
			//݂
            if (lpnmhdr->hwndFrom == hList) {
				tab =tab_r;
				setlistbuffers(tab, iIndex, szDir, szBuf, NList, file);
				return ListNotify(tab, NDir, szDir, szBuf, iIndex, hWnd, wp, lp);
        }
            break;
        case WM_COMMAND:
			if(LOWORD(wp)>=bothdirIDBASE && LOWORD(wp)<bothdirIDBASE+1000 )
			{
				loadbothdir( LOWORD(wp) - bothdirIDBASE+1, LDir.cd(), RDir.cd() );
				SetWindowText(hDirEdit, RDir.cd());
				SetWindowText(hDirEditL, LDir.cd());
				reloadbothdir();
				break;
			}
			if(LOWORD(wp)>=localdirIDBASE && LOWORD(wp)<localdirIDBASE+1000 )
			{
				GetMenuString(hLeftMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                NDir->cd(szBuf);
				reloadtab();
				break;
			}
			if(LOWORD(wp)>=remotedirIDBASE && LOWORD(wp)<remotedirIDBASE+1000 )
			{
				GetMenuString(hRemoteMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                RDir.cd(szBuf);
				reloadremote();
				break;
			}
			if(LOWORD(wp)>=sendIDBASE && LOWORD(wp)<sendIDBASE+1000 )
			{
				GetMenuString(hSendtoMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                ShellExecute(NULL, NULL, 
					szBuf, 
					quote(GetFullName(commandline, file, NDir->cd(), MAX_PATH)),
					sendtoPath, SW_SHOW);
				break;
			}
			if(LOWORD(wp)>=findIDBASE && LOWORD(wp)<findIDBASE+1000 )
			{
				GetMenuString(hFindMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                setfilter(szBuf);
				reloadtab();
				break;
			}
			if(LOWORD(wp)>IDM_CMD_BASE && LOWORD(wp)<IDM_CMD_MAX )
			{
				myexec( cmd( file, NDir->cd(), LOWORD(wp) -IDM_CMD_BASE ) );
				break;
			}
            switch (LOWORD(wp)) {
				case ID_DIR:
					switch (HIWORD (wp))
					 {
					 case BN_CLICKED:
						reloadClick(hDirEdit, szDir, RDir, tab_r);
						 break;
					 default:
						 break;
					}
					break;
				case ID_DIRL:
					switch (HIWORD (wp))
					 {
					 case BN_CLICKED:
						 reloadClick(hDirEditL, szDir, LDir, tab_l);
						 break;
					 default:
						 break;
					}
					break;
				case ID_BUTTON:
					switch (HIWORD (wp))
					 {
					 case BN_CLICKED:
						 if( st.connect == FALSE )
						 {
							 SendMessage(hWnd, WM_COMMAND, IDM_CONNECT, 0);
						 }
						 /*
						 else
						 {
							 if (hLastList == hListL) 
							 {
								 SendMessage(hWnd, WM_COMMAND, IDM_UPLOAD, 0);
							 }
							 if (hLastList == hList) 
							 {
								 SendMessage(hWnd, WM_COMMAND, IDM_DOWNLOAD, 0);
							 }
						 }
						 */
						return 0 ;
					 default:
						 break;
					 }
					break;
				case ID_UP:
					SendMessage(hWnd, WM_COMMAND, IDM_UPLOAD, 0);
					break;
				case ID_DOWN:
					SendMessage(hWnd, WM_COMMAND, IDM_DOWNLOAD, 0);
					break;
				case ID_STATICL:
					if( HIWORD(wp) == EN_UPDATE) GetWindowText(hDirEditL,szDir,100) ;setstatusnum(strlen(szDir));
					break;
				case IDM_LISTR_ONLY:
					ListLWidth =0;
					SetFocus(hList);
					resize();
					break;
				case IDM_LISTL_ONLY:
					ListLWidth =100;
					SetFocus(hListL);
					resize();
					break;
				case IDM_LISTL_WIDTH_1:
					ListLWidth =85;
					resize();
					break;
				case IDM_LISTL_WIDTH_2:
					ListLWidth =50;
					resize();
					break;
				case IDM_LISTL_WIDTH_3:
					ListLWidth =15;
					resize();
					break;
				case IDM_WINMODE:
					nextwinmode();
					resize();
					break;
				case IDM_HIS_BACKWARD:
					NDir->hisback();
					reloadtab();
					break;
				case IDM_HIS_FORWARD:
					NDir->hispos(1);
					reloadtab();
					break;
				case IDM_SameDir:
					if(tab==tab_l) *NDir=RDir;
					if(tab==tab_r) *NDir=LDir;
					reloadtab();
					break;
				case IDM_SSameDir:
					if(tab==tab_l) RDir =*NDir;
					if(tab==tab_r) LDir =*NDir;
					reloadother();
					break;
				case IDM_change_mode_sw:
					if(ascii==TRUE) SendMessage(hWnd,WM_COMMAND,IDM_changeb_mode,0);
					else SendMessage(hWnd,WM_COMMAND,IDM_change_mode,0);
					break;
				case IDM_UP_BUTTON:
					buttonSw();
					SendMessage(hWnd, WM_SIZE, 0 ,sizelp);
					break;
				case IDM_LOCAL_CREATE_FILE:
					MyCreatFile(hWnd, NDir);
					reloadlocal();
					break;
				case IDM_NEW_FILE:
					MyCreatBlankFile();
					reloadlocal();
					break;
				case IDM_COMPARE:
					CompareList(NList, NXList);
					break;
				case IDM_REV_SELECT:
					SelectReverse(NList);
					break;
				case IDM_RENAME_2:
					if(MyRename(*NDir)) reloadtab();
					break;
				case IDM_RENAME:
                        iIndex = ListView_GetNextItem(NList, -1, LVNI_SELECTED);
                        setselbuf(iIndex, szDir, szBuf, NList);
                        if (strncmp(szBuf, isdirectory,5) != 0) {
							if(localrename(hWnd, NList, NDir, &myfname)) {
								reloadtab();
							}
							else setstatus("l[s");
                            break;
                        }
						else
						{
							
						}
					break;
				case IDM_SAVE_WINS_HOME:
					if( ! GetStrDlg("z[ɐݒ肵܂", commandline) ) break;
					savehomebothdir( LDir.cd(), RDir.cd());
					break;
				case IDM_LOAD_WINS_HOME:
					loadhomebothdir( LDir.cd(), RDir.cd() );
					SetWindowText(hDirEdit, RDir.cd());
					SetWindowText(hDirEditL, LDir.cd());
					reloadbothdir();
					break;
				case IDM_SAVE_WINS:
					if( DialogBoxParam(hInst, "mycreatedir", hWnd, (DLGPROC)GetNameProc,(LPARAM)(setname)) == IDCANCEL) break;
					savebothdir(setname, LDir.cd(), RDir.cd());
					break;
				case IDM_SAVE_DIRLOCAL:
					savelocaldir(tab, NDir->cd());
					break;
				case IDM_LOAD_DIRLOCAL:
					loaddirlocal(szDir);
					LDir.cd(szDir);
					setstatus(szDir);
					reloadlocal();
					break;
				case IDM_OPEN_CUR:
                    ShellExecute(NULL, "open", "explorer", NDir->cd(), NULL, SW_SHOW);
					break;
				case IDM_OPEN_INI:
                    openinitdir();
					break;
				case IDM_EDIT:
					NDir->cd(".");
                        iIndex = ListView_GetNextItem(NList, -1, LVNI_SELECTED);
                        setselbuf(iIndex, szDir, szBuf, NList);
                        if (strncmp(szBuf, isdirectory,5) != 0) {
                            ShellExecute(NULL, "open",editor,szDir, NULL, SW_SHOW);
                            break;
                        }
						else
						{
							ShellExecute(NULL, "open","explorer",szDir, NULL, SW_SHOW);
						}
					break;

                case IDM_LOCALDRIVE:
                    ChangeLocalDrive(hWnd, *NDir, hImage);
					GetCurrentDirectory(MAX_PATH,NDir->cd());
                    reloadtab();
                    break;
                case IDM_EDIT_INIT:
					openinit();
                    break;
                case IDM_OPEN_KEY_FILE:
					openkeyfile();
                    break;
                case IDM_FIND:
					if( MyFilter(hWnd) )
					{
						reloadtab();
					}
                    break;
				case IDM_EXT_SETCOLOR:
					if( GetStrDlg( "gq", ext ) )
					{
						setExtPaint(ext);
						SetFocus(hWnd);
					}
					break;
				case IDM_EXT_SETCOLOR_THIS:
					setExtPaint(NList);
					colorrefresh(); // Ȃɂredraw
					break;
                case IDM_FIND_MORE:
					if( GetStrDlg( "?", Filter ) )
					{
						//ListFilter(hWnd);
						reloadtab();
					}
                    break;
                case IDM_FIND2:
					if( GetStrDlg( "**", Filter ) )
						setsel(NList,Filter);
                    break;
                case IDM_END:
                    SendMessage(hWnd, WM_CLOSE, 0, 0);
                    break;
                case IDM_AUTO:
					if( PopFileOpenDlg(hWnd, file, NULL) ) batch(file);
					else setstatus("LZ");
                    break;
                case IDM_AUTOFILE_EDIT:
					if( PopFileOpenDlg(hWnd, file, NULL) ) editbatch(file);
					else setstatus("LZ");
                    break;
                case IDM_AUTOFILE_FILTER:
					filefilter=FilterAuto;
					reloadlocal();
                    break;
                case IDM_DOWNLOAD:
					MyDown(hWnd, hList, hListL);
                    reloadlocal();
                    break;
                case IDM_UPLOAD:
					MyUp(hWnd, hList,hListL);
					reloadremote();
                    break;
                case IDM_COPY_HERE:
					MyCopyHere(hWnd, *NDir, NList);
					reloadtab();
                    break;
                case IDM_COPY:
					if(tab == tab_l) msgUp();
					if(tab == tab_r) msgDown();
                    break;
                case IDM_UPLOAD_CUT:
					start=0;
					len=0;
					DialogBoxParam(hInst, "mycreatedir", hWnd, (DLGPROC)GetLenProc,(LPARAM)(NDir));
					MyCutUp(start,len);
					reloadother();
                    break;
                case IDM_HERE_CUT:
					start=0;
					len=0;
					DialogBoxParam(hInst, "mycreatedir", hWnd, (DLGPROC)GetLenProc,(LPARAM)(NDir));
					MyCutHere(start,len);
					reloadtab();
                    break;
                case IDM_DELFILELOCAL:
					if( MyDelFile(NList,*NDir) ==0 ) break;
					if(NList==hListL) reloadlocal();
					else reloadremote();
                    break;
                case IDM_DELFILE://DeleteFile
                    MyDelFile(NList,*NDir);
                    reloadremote();
                    break;
                case IDM_CHECK_CDIR:
                    GetCurrentDirectory(100,commandline);
				//	strcat(commandline,file);
				//	strcat(commandline,szBuf);
					SetWindowText(hEdit,commandline);
                    break;
                case IDM_ZIP:
					if( MyZip(*NDir, *NXDir, NList) ) reloadother();
					break;
                case IDM_LZH:
					if( MyLzh(*NDir, *NXDir, NList) ) reloadother();
					break;
                case IDM_UnLZH:
					if( MyUnLzh(*NDir, *NXDir, NList) ) reloadother();
					break;
                case IDM_CHECK_VOL:
                    GetVol(100,commandline);//
					SetWindowText(hEdit,commandline);
					break;
                case IDM_EXCHANGE:
                    Exchange(LDir, RDir);
					reloadbothdir();
                    break;
                case IDM_LOCAL_CREATEDIR:
                    MyCreatDir(hWnd, NDir);
					reloadtab();
                    break;
                case IDM_REMOVEDIR_LOCAL:
                    if( MyRemoveDir(NList) ) reloadtab();
                    break;
                case IDM_UPDIRFTP:
                    RDir.cd( "..");
                    reloadremote();
                    break;
                case IDM_R_DIRREMOTE:
                    RDir.cd(".");
                    RDir.SetItemNum( SetMyLocalDir(hWnd, RDir, hDirEdit, hImage) );
                    SortData.hwndList = hList;
                    SortData.isortSubItem = isortsubno;
                    SortData.iUPDOWN = sortsubno[isortsubno];
                    ListView_SortItems(hList, MyCompProc, &SortData);
					filefilter=FilterAll;//reset 
					SetFocus(hList);
                    break;
                case IDM_R_DIRLOCAL:
                    LDir.cd(".");
                    LDir.SetItemNum( SetMyLocalDir(hWnd, LDir, hDirEditL, hImage) );
                    SortData.hwndList = hListL;
                    SortData.isortSubItem = isortsubno;
                    SortData.iUPDOWN = sortsubno[isortsubno];
                    ListView_SortItems(hListL, MyCompProc, &SortData);
					filefilter=FilterAll;//reset 
					SetFocus(hListL);
                    break;
                case IDM_ROOTDIR:
                    NDir->cdroot();
                    reloadtab();
                    break;
                case IDM_UPDIRLOCAL:
                    NDir->cd("..");
                    reloadtab();
                    break;
                case IDM_RELOAD_BOTH:
                    reloadlocal();
					reloadremote();
					setstatus(LDir.cd(),RDir.cd());
                    break;
                case IDM_OVERWRITE:
					overwrite(hEdit);
                    break;
                case IDM_WINDOW_ALL:
					editmode();
					resize();
                    break;
                case IDM_WINDOW_MAX:
					GetWindowRect(hWnd, &Last);
					MoveWindow(hWnd, Max.left, Max.top, Max.right-Max.left, Max.bottom-Max.top, TRUE);
                    break;
                case IDM_WINDOW_SMALLER:
					GetWindowRect(hWnd, &Last);
					MoveWindow(hWnd, Last.left +smallW, Last.top +smallH, Last.right -Last.left -2*smallW, Last.bottom -Last.top -2*smallH, TRUE);
                    break;
                case IDM_WINDOW_BIGGER:
					GetWindowRect(hWnd, &Last);
					MoveWindow(hWnd, Last.left -smallW, Last.top -smallH, Last.right -Last.left +2*smallW, Last.bottom -Last.top +2*smallH, TRUE);
                    break;
                case IDM_WINDOW_INI:
					//MoveWindow(hWnd, winpos.x, winpos.y, winpos.wx, winpos.wy, TRUE);
					MoveWindow(hWnd, Last.left, Last.top, Last.right-Last.left, Last.bottom-Last.top, TRUE);
                    break;
                case IDM_WINDOW_LIST:
					listmode();
					resize();
                    break;
                case IDM_WINDOW_EDIT:
					editonlymode();
					resize();
                    break;
                case IDM_PicOrgDown:
					win.mvOrg(0,-10);
                    break;
                case IDM_PicOrgUp:
					win.mvOrg(0,10);
                    break;
                case IDM_PicOrgRight:
					win.mvOrg(10,0);
                    break;
                case IDM_PicOrgLeft:
					win.mvOrg(-10,0);
                    break;
                case IDM_PicRateUp:
					win.rateUp();
                    break;
                case IDM_PicRateDown:
					win.rateDown();
                    break;
                case IDM_PicRateReset:
					win.rateReset();
                    break;
                case IDM_PicReset:
					memmapReset();
                    break;
                case IDM_DEL_MENU:
					if(showmenu) 
					{
						SetMenu(hWnd,NULL);
						showmenu =FALSE;
					}
					else 
					{
						SetMenu(hWnd,hMenu);
						showmenu =TRUE;
					}
                    break;
                case IDM_SORT1:
					sortlist( NList, 1 );
                    break;
                case IDM_SORT2:
					sortlist( NList, 2 );
                    break;
                case IDM_SORT3:
					sortlist( NList, 3 );
                    break;
                case IDM_SORT4:
					sortlist( NList, 4 );
                    break;
                case IDM_SORT5:
					sortlist( NList, 5 );
                    break;
                case IDM_COLOR_REV:
					colorRev(hList);
					setBrush();
					//setlistcolor(NList);
					paintf =TRUE;
					colorrefresh();
                    break;
                case IDM_COM:
					if( GetStrDlg( "R}hs", commandline ) )
						myexec( cmdDirect( file, NDir->cd(), commandline) );
                    break;
                case IDM_COM_NUM:
					if( GetStrDlg( "R}hԍw", commandline ) )
						myexec( cmdByNum( file, NDir->cd(), commandline) );
                    break;
            }
            break;
	    case WM_CTLCOLOREDIT:
		case WM_CTLCOLORLISTBOX:
			if(paintf)
			{
				HDC hDC = (HDC)wp;
				SetBkMode(hDC, OPAQUE);		// wi//s͓߂
				SetTextColor(hDC, listtextColor);	// eLXg̐F
				SetBkColor(hDC,listtextBkColor);	// eLXgĂ镔̔wi̐F
				return (LRESULT) hbrush;//CreateSolidBrush(listtextbkcolor);	// eLXgĂȂ̔wi̐F
			}
			break;
		case WM_PAINT:
			if(picshowflg)
				bmppaint(hWnd, msg, wp,lp,file);
			else
			{
				GetClientRect (hWnd, &rect) ;
				hdc =BeginPaint(hWnd, &ps);
					SetBkMode(hdc, OPAQUE);
				SelectObject( hdc, hbrush ) ;
				if(paintf) Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
				
				EndPaint(hWnd,&ps);
			}
			return 0;
        case WM_SETFOCUS:
			SetFocus( NList );
			break;
        case WM_CLOSE:
            GetWindowRect(hWnd, &rc);
            winpos.x = rc.left;
            winpos.y = rc.top;
            winpos.wx = rc.right - rc.left;
            winpos.wy = rc.bottom -rc.top;
			savelastdir( 1, LDir.cd());
			savelastdir( 2, RDir.cd());
            MySaveInitialData( &winpos);
            ImageList_Destroy(hImage);
            DestroyWindow(hList);
            DestroyWindow(hListL);
            DestroyWindow(hDirL);
            DestroyWindow(hDir);
            DestroyWindow(hDirEdit);
            DestroyWindow(hDirEditL);
            DestroyWindow(hEdit);
            DestroyWindow(hUp);
            DestroyWindow(hDown);
			DeleteObject(hbrush);
            DestroyWindow(hWnd);
			FreeDll();
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return (DefWindowProc(hWnd, msg, wp, lp));
    }
    return 0;
}


void setfilenameonRename(HWND hListFrom, dirw *dir, FNAME *lpfname)
{
    int iIndex;

	strcpy(lpfname->szFName,"");
    iIndex = ListView_GetNextItem(hListFrom, -1, LVNI_SELECTED);
    ListView_GetItemText(hListFrom, iIndex, pos.name, lpfname->szFName, MAX_PATH);
    dir->GetCurrentDirectory( 0,lpfname->szLocalFileName);
	strcpy(lpfname->path, lpfname->szLocalFileName);
    strcat(lpfname->szLocalFileName, "\\");
    strcat(lpfname->szLocalFileName, lpfname->szFName);
}


long MyDelFile(HWND hList,dirw &dir)
{
    int iIndex;
	long count =0;
	char buffer[MAX_INFO],szMsg[MAX_INFO];
	int co =LGetSelectedCount( hList );
	sprintf(szMsg, "%d̃t@C %s\..", co, dir.cd());
	if( MessageBox(hList,"폜܂H",szMsg, MB_OKCANCEL)==IDCANCEL ) return 0;

	dir.cd(".");
	strcpy(buffer,"");
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, buffer, sizeof(buffer));
		wsprintf(szMsg,
			"%s\\%s폜܂B%d",
			dir.cd(), buffer,iIndex+1);
	    setstatus(szMsg);
		//Mes( szFile );
		if( DeleteFile(buffer) ) count++;
	}
	return count;
}

BOOL MyRemoveDir(HWND hList)
{
    int iIndex;
	char buffer[MAX_INFO];

	strcpy(buffer,"");
    iIndex = ListView_GetNextItem(hList, -1, LVNI_SELECTED);
    ListView_GetItemText(hList, iIndex, pos.name, buffer, MAX_PATH);
	if( MessageBox(hList,"tH_폜܂H",buffer, MB_OKCANCEL)==IDCANCEL ) return FALSE;
	if(RemoveDirectory(buffer)) 
	{
		setstatus("폜܂");
		return TRUE;
	}
	else 
	{
		setstatus("폜o܂ł");
		return FALSE;
	}
}


BOOL localrename(HWND hWnd,HWND hList, dirw *Dir , FNAME *lpfname)
{
	setfilenameonRename(hList, Dir, lpfname);
    strcpy(lpfname->szLocalFileName, lpfname->szFName);
	if (DialogBoxParam(hInst, "MYRENAME",
		hWnd, (DLGPROC)MyGetFNameProc, (LPARAM)&myfname) == IDCANCEL)
		return FALSE;
	if( rename(myfname.szFName,myfname.szLocalFileName) ==-1) return FALSE;
	return TRUE;
}


LRESULT CALLBACK GetFromToProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static FNAME fname;
    static HWND hFName, hLocalFName, txt1, txt2;
	static iset *mset;

    switch (msg) {
        case WM_INITDIALOG:
			SetWindowText(hDlg,"OA؂");
            mset = (iset*)(lp);
            hFName = GetDlgItem(hDlg, IDC_FNAME);
            hLocalFName = GetDlgItem(hDlg, IDC_LOCALFILE);
            txt1 = GetDlgItem(hDlg, IDC_STATIC1);
            txt2 = GetDlgItem(hDlg, IDC_STATIC2);
            Edit_SetText(txt1, "from");
			Edit_SetText(txt2, "to");
            SetFocus(hFName);
            break;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    Edit_GetText(hFName, fname.szFName, sizeof(fname.szFName));
                    Edit_GetText(hLocalFName, fname.szLocalFileName,
                        sizeof(fname.szLocalFileName));
					sscanf(fname.szLocalFileName,"%d",&(mset->to));
					sscanf(fname.szFName,"%d",&mset->from);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}



LRESULT CALLBACK MyGetFNameProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static FNAME *lpfname;
    static HWND hFName, hLocalFName, txt1, txt2;

    switch (msg) {
        case WM_INITDIALOG:
            lpfname = (FNAME *)lp;
			SetWindowText(hDlg, lpfname->path );
            hFName = GetDlgItem(hDlg, IDC_FNAME);
            hLocalFName = GetDlgItem(hDlg, IDC_LOCALFILE);
            txt1 = GetDlgItem(hDlg, IDC_STATIC1);
            Edit_SetText(hFName, lpfname->szFName);
            Edit_SetText(hLocalFName, lpfname->szLocalFileName);
            //Edit_SetText(txt1, "Ă");
            SetFocus(hLocalFName);
            break;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    Edit_GetText(hFName, lpfname->szFName, sizeof(lpfname->szFName));
                    Edit_GetText(hLocalFName, lpfname->szLocalFileName,
                        sizeof(lpfname->szLocalFileName));
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}

void ChangeLocalDrive(HWND hWnd, dirw &dir, HIMAGELIST hImage)
{
    HINSTANCE hInst;
    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    DialogBoxParam(hInst, "MYDRIVE", hWnd, (DLGPROC)MyDriveProc, (LPARAM)&dir);
    return;
}


LRESULT CALLBACK MyDriveProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static HWND hDrvList;
    static HWND hListL, hDirEditL, hParent;
    char szDrv[4];
	dirw *dir;
    HWNDSET *lphset;
    static HIMAGELIST hImage;

    switch (msg) {
        case WM_INITDIALOG:
            dir = (dirw *)lp;
            hListL = dir->getList();
            hDirEditL = dir->getEdit();
            hImage = dir->getImage();
            hParent = GetParent(hDlg);
            hDrvList = GetDlgItem(hDlg, IDC_LIST1);
            DlgDirList(hDlg, "*.*", IDC_LIST1, 0, DDL_DRIVES);
			OldDrvList =(WNDPROC) SetWindowLong (hDrvList, GWL_WNDPROC, (LPARAM) DrvListProc);

            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    DlgDirSelectEx(hDlg, szDrv, sizeof(szDrv), IDC_LIST1);
                    strcat(szDrv, "\\");
                    SetCurrentDirectory(szDrv);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}

void calcpercent( char *buff, char *file, DWORD &len)
{
	DWORD size =getfilesize(file);
	int percent;
	int n=strlen(buff);
	buff[n-1] =0;
	sscanf(buff,"%ld",&percent);
	if(percent>=100) len =size;
	else len = size  * ((float)percent/100);
}

LRESULT CALLBACK GetLenProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static HWND hList;
    static HWND hListL, hDirEditL, hParent;
    char buff[100];
    HWNDSET *lphset;
    static HIMAGELIST hImage;
	static dirw *dir;

    switch (msg) {
        case WM_INITDIALOG:
			dir =(dirw*) lp;
			SetWindowText(hDlg, "");
			//SetDlgItemText(hDlg,IDC_EDIT1, dir->cd());
			dir->cd(".");
            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
					GetDlgItemText(hDlg,IDC_EDIT1,buff,MAX_PATH);
					if( strchr(buff,'%') == NULL ) sscanf(buff,"%ld",&len);
					else calcpercent( buff, dir->getfile() ,len );
					setstatusnum(len);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}

LRESULT CALLBACK GetNameProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static HWND hList;
    static HWND hListL, hDirEditL, hParent;
    HWNDSET *lphset;
    static HIMAGELIST hImage;
	static char *name;

    switch (msg) {
        case WM_INITDIALOG:
			name =(char*) lp;
			SetWindowText(hDlg, "O");
            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
					GetDlgItemText(hDlg,IDC_EDIT1,name,MAX_PATH);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}


void MyCutCopy(dirw &Fdir,dirw &Tdir,DWORD fr, DWORD len)
{
	HWND hList =NList;
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	Fdir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, szFile, sizeof(szFile));
		GetFullName(ToFile, szFile, ToPath, MAX_PATH);
		GetFullName(FromFile, szFile, FromPath, MAX_PATH);
		wsprintf(szMsg,
			"%s >> %s , %d",
			FromFile, ToFile,len);
		cutcopy( FromFile, ToFile, fr, len );
	}
	savelocaldir(1, FromPath);
    return;
}

int search(HWND hList, char *buf)
{
	char buffer[1000];
	int i =0;
	int max =ListView_GetItemCount(hList);
	while(i<max) 
	{
		ListView_GetItemText(hList, i, pos.name, buffer, 1000);
		if( strlen(buffer) == 0) continue;
		if( strcmp(buffer, buf) == 0 ) return i; 
		i++;
	}
	return -1;
}

void CompareList(HWND hList1, HWND hList2)
{
	ListNonSelected( hList1 );
	ListNonSelected( hList2 );
	int i =0, ans;
	int max1=ListView_GetItemCount(hList1);
	while(i<max1) 
	{
		ListView_GetItemText(hList1, i, pos.name, buffer, 1000);
		if( strlen(buffer) == 0) continue;
		ans =search(hList2, buffer);
		if( ans >=0 )
		{
			ListSelected(hList1,i);
			ListSelected(hList2,ans);
		}
		i++;
	}
}

void SelectReverse(HWND hList)
{
	int i =0;
	UINT ans;
	int max =ListView_GetItemCount(hList);
	while( i < max )
	{
		ans = ListView_GetItemState(hList,i,LVIS_SELECTED);
		if ( ans > 0 )
		{
			ListSelected( hList, i, FALSE);
		}
		else
		{
			ListSelected( hList, i, TRUE);
		}
		i++;
	}
}


void setsel(HWND hList, char *key)
{
	char buffer[1000];
	int i =0;
	int max=ListView_GetItemCount(hList);
	while(i<max) 
	{
		ListView_GetItemText(hList, i, pos.name, buffer, 1000);
		if( strstr(buffer, key) != NULL ) ListSelected(hList,i);
		if( strlen(buffer) == 0) break;
		i++;
	}
}


BOOL MyZip(dirw &Fdir,dirw &Tdir,HWND hList)
{
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	Fdir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	BOOL flag=FALSE; 

	if( ! dllLoad("zip32j.dll", "Zip") ) return FALSE;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, szFile, sizeof(szFile));
		if(strlen(szFile)==0 || strcmp(szFile,".")==0 || strcmp(szFile, "..")==0) continue;
		
		MyGetFullName(FromFile, szFile, FromPath, MAX_PATH);
		if(!flag) 
		{
			flag=TRUE;
			MyGetFullName(ToFile, szFile, ToPath, MAX_PATH);
		};
		wsprintf(szMsg,
			"zip %s >> %s.zip , %d",
			FromFile, ToFile,iIndex);
	    setstatus(szMsg);
		DoZip( hList, ToFile, FromFile);
	}
	FreeDll();
	savelocaldir(1, FromPath);
    return TRUE;
}

BOOL MyLzh(dirw &Fdir,dirw &Tdir,HWND hList)
{
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	Fdir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	BOOL flag=FALSE; 

	if( ! dllLoad("unlha32.dll", "Unlha") ) return FALSE;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, szFile, sizeof(szFile));
		if(strlen(szFile)==0 || strcmp(szFile,".")==0 || strcmp(szFile, "..")==0) continue;
		
		MyGetFullName(FromFile, szFile, FromPath, MAX_PATH);
		if(!flag) 
		{
			flag=TRUE;
			MyGetFullName(ToFile, szFile, ToPath, MAX_PATH);
		};
		wsprintf(szMsg,
			"lha %s >> %s.lzh , %d",
			FromFile, ToFile,iIndex);
	    setstatus(szMsg);
		DoLzh( hList, ToFile, FromPath, szFile);
	}
	FreeDll();
	savelocaldir(1, FromPath);
    return TRUE;
}

BOOL MyUnLzh(dirw &Fdir,dirw &Tdir,HWND hList)
{
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	Fdir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	BOOL flag=FALSE; 

	if( ! dllLoad("unlha32.dll", "Unlha") ) return FALSE;
	iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
	if (iIndex == -1) return FALSE;
	ListView_GetItemText(hList, iIndex, pos.name, szFile, sizeof(szFile));
	MyGetFullName(FromFile, szFile, FromPath, MAX_PATH);
	wsprintf(szMsg,
		"unlha %s >> %s , %d",
			FromFile, ToPath, iIndex);
	setstatus(szMsg);
	DoUnLzh( hList, ToPath, FromFile);
	FreeDll();
	savelocaldir(1, FromPath);
    return TRUE;
}

// tH_ɓ_1Ȃǂĕ

void MyCopyHere(HWND hWnd, dirw &Tdir,HWND hList)
{
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], FromPath[MAX_PATH];
    char *ToPath =FromPath;

    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, szFile, sizeof(szFile));
		GetFullName(FromFile, szFile, ToPath, MAX_PATH);
		makenewfilenameEx(FromFile, ToFile);
		wsprintf(szMsg,
			"%s >> %s , %d",
			FromFile, ToFile,iIndex);
	    setstatus(szMsg);
		//Mes( szFile );CopyFileEx()
		CopyFileOne( FromFile, ToFile, FALSE );
		colorrefresh();
	}
	savelocaldir(1, FromPath);
    return;
}

void MyCopy(dirw &Fdir,dirw &Tdir,HWND hList)
{
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	Fdir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, szFile, sizeof(szFile));
		MyGetFullName(ToFile, szFile, ToPath, MAX_PATH);
		MyGetFullName(FromFile, szFile, FromPath, MAX_PATH);
		wsprintf(szMsg,
			"%s >> %s , %d",
			FromFile, ToFile,iIndex);
	    setstatus(szMsg);
		//Mes( szFile );CopyFileEx()
		CopyFileOne( FromFile, ToFile, FALSE );
		colorrefresh();
	}
	savelocaldir(1, FromPath);
    return;
}

// AiFroiTo܂ōăRs[
void makenewnameCut(char *from, char *to, int iFr, int iTo)
{
	if( strlen(from)<iTo ) return;
	int j=0;
	for( int i=0; i<strlen(from)+1 ; i++)
	{
		if(i<iFr || i>iTo ) {
			to[j] = from[i];
			j++;
		}
	}
}

BOOL MyRename(dirw &dir)
{
	iset mset;
	if (DialogBoxParam(hInst, "MYRENAME",
		hMainWnd, (DLGPROC)GetFromToProc, (LPARAM)&mset) == IDCANCEL)
		return FALSE;
    int iIndex;
	HWND hList =dir.getList();
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], File[MAX_PATH], FileN[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	dir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, File, sizeof(File));
		makenewnameCut(File, FileN, mset.from-1, mset.to-1);
		GetFullName(ToFile, FileN, FromPath, MAX_PATH);
		GetFullName(FromFile, File, FromPath, MAX_PATH);
		wsprintf(szMsg,
			"rename %s > %s , %d",
			FromFile, ToFile,iIndex);
	    setstatus(szMsg);
		//Mes( szFile );
		rename( FromFile, ToFile );
	}
	savelocaldir(1, FromPath);
    return TRUE;
}

void MyDown(HWND hWnd, 
          HWND hList, HWND hListL)
{
	MyCopy(RDir,LDir,hList);
}

void MyUp(HWND hWnd, 
          HWND hList, HWND hListL)
{
	MyCopy(LDir,RDir,hListL);
}

void MyCutUp(DWORD st, DWORD len)
{
	MyCutCopy(*NDir,*NXDir,st,len);
}

void MyCutHere(DWORD st, DWORD len)
{
	HWND hList =NList;
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH],Dummy[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	NDir->GetCurrentDirectory(dwSize, ToPath);
	NDir->GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, pos.name, szFile, sizeof(szFile));
		GetFullName(ToFile, szFile, ToPath, MAX_PATH);
		GetFullName(FromFile, szFile, FromPath, MAX_PATH);
		wsprintf(Dummy, "%s.$$$", FromFile);
		rename( FromFile, Dummy );
		wsprintf(szMsg,
			"cut , %d",
			len);
		cutcopy( Dummy, ToFile, st, len );
	}
	savelocaldir(1, FromPath);
    return;
}



void MyCreatDir(HWND hWnd, dirw *dir)
{
    char szDir[MAX_PATH];
	char command[MAX_PATH*2];
    HINSTANCE hInst;
    int iIndex;

    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    iIndex = DialogBoxParam(hInst, "MYCREATEDIR", hWnd,
        (DLGPROC)MyCreateDirProc, (LPARAM)szDir);
    if (iIndex == IDCANCEL)
        return;
	wsprintf(command,"mkdir %s",szDir);
	system(command);
    return;
}

BOOL MyFilter(HWND hWnd)
{
    char str[MAX_FILTER]="filter";
	char command[MAX_PATH*2];
    int iIndex;

    iIndex = DialogBoxParam(hInst, "MYCREATEDIR", hWnd,
        (DLGPROC)MyCreateDirProc, (LPARAM)str);
    if (iIndex == IDCANCEL)
        return FALSE;
	setfilter(str);
    return TRUE;
}


//JgfBNgɃeLXgt@C쐬A㏑`FbNȂ

void MyCreatFile(HWND hWnd, dirw *)
{
    char szDir[MAX_PATH]="VKeLXg쐬";
//	char command[MAX_PATH*2];
    HINSTANCE hInst;
    int iIndex;

    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    iIndex = DialogBoxParam(hInst, "MYCREATEDIR", hWnd,
        (DLGPROC)MyCreateDirProc, (LPARAM)szDir);
    if (iIndex == IDCANCEL)
        return;
	ofstream ou;
	if(strlen(szDir)>0) ou.open(szDir);
    return;
}

//JgfBNgɎԖeLXgt@C쐬A㏑`FbNȂ

void MyCreatBlankFile()
{
    char szDir[MAX_PATH];
	SYSTEMTIME st;
	char jikan[16];
	char form[]="%04d%02d%02d-%02d%02d%02d.txt";

	GetLocalTime(&st);
	wsprintf(
		szDir,
		form,
	
		st.wYear,
		st.wMonth,
		st.wDay,

		st.wHour,
		st.wMinute,
		st.wSecond
	);
	ofstream ou;
	if(strlen(szDir)>0) ou.open(szDir);
    return;
}



LRESULT CALLBACK MyCreateDirProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static char *lpDirName;
    static HWND hEdit;

    switch (msg) {
        case WM_INITDIALOG:
            lpDirName = (char *)lp;
            hEdit = GetDlgItem(hDlg, IDC_EDIT1);
			if(lpDirName[0]!=0) SetWindowText(hDlg, lpDirName);
			if(strcmp(lpDirName, "filter") == 0 ) SetWindowText(hEdit, Filter);
            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    Edit_GetText(hEdit, lpDirName, MAX_PATH);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}


HWND MakeMyList(HWND hWnd,int id)
{
    HWND hList;
    DWORD dwStyle;
    HINSTANCE hInst;
	DWORD style =WS_CHILD | WS_VISIBLE | LVS_REPORT | WS_BORDER | LVS_SHOWSELALWAYS;
	if(!columnhead) style |= LVS_NOCOLUMNHEADER;

    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    hList = CreateWindowEx(0, WC_LISTVIEW, "",
        style , 0, 0, 0, 0, hWnd, (HMENU) id, hInst, NULL);
    dwStyle = ListView_GetExtendedListViewStyle(hList);
    dwStyle |= LVS_EX_FULLROWSELECT | 
         LVS_EX_HEADERDRAGDROP;//LVS_EX_GRIDLINES |
    ListView_SetExtendedListViewStyle(hList, dwStyle);

	if(paintf)
	{
		setlistcolor(hList);
	}

    return hList;
}
