
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>
#include <iostream.h>
#include <fstream.h>
#include <wininet.h>
#include <windowsx.h>
#include <commctrl.h>
#include "resource.h"
#include "myfilemv.h"
#include "initial.h"
#include "listview.h"
#include "paintflag.h"
#include "status.h"


int CALLBACK MyCompProc(LPARAM lp1, LPARAM lp2, LPARAM lp3)
{
    static LVFINDINFO lvf;
    static int nItem1, nItem2;
    static char buf1[MAX_PATH], buf2[MAX_PATH];
    SORTDATA *lpsd;

    lpsd = (SORTDATA *)lp3;

    lvf.flags = LVFI_PARAM;
    lvf.lParam = lp1;
    nItem1 = ListView_FindItem(lpsd->hwndList, -1, &lvf);

    lvf.lParam = lp2;
    nItem2 = ListView_FindItem(lpsd->hwndList, -1, &lvf);
    
    ListView_GetItemText(lpsd->hwndList,
        nItem1, lpsd->isortSubItem, buf1, sizeof(buf1));

    ListView_GetItemText(lpsd->hwndList,
        nItem2, lpsd->isortSubItem, buf2, sizeof(buf2));
    if (lpsd->isortSubItem != 1 && lpsd->isortSubItem != 3) {
        if (lpsd->iUPDOWN == UP) {
            return(stricmp(buf1, buf2));
        } else {
            return(stricmp(buf1, buf2) * -1);
        }
    } else {
        if (lpsd->iUPDOWN == UP) {
            if (atoi(buf1) > atoi(buf2))
                return 1;
            else if (atoi(buf1) == atoi(buf2))
                return 0;
            else
                return -1;
        } else {
            if (atoi(buf1) > atoi(buf2))
                return -1;
            else if (atoi(buf1) == atoi(buf2))
                return 0;
            else
                return 1;
        }

    }
}

void ListSelected(HWND hList, int i, BOOL fl)
{
	if(fl) 
	{
		ListView_SetItemState( hList, i, LVIS_SELECTED, LVIS_SELECTED);
	}
	else 
	{
		ListView_SetItemState( hList, i, 0, LVIS_SELECTED);
	}
}

void ListNonSelected( HWND hList )
{
	int i =0;
	int max =ListView_GetItemCount( hList );
	while( i< max )
	{
		ListView_SetItemState( hList, i, 0, LVIS_SELECTED);
		i++;
	}
}

void initlistcolor()
{
	//listtextcolor =ListView_GetTextColor(hwnd);
	//listtextbkcolor =ListView_GetTextBkColor(hwnd);
	//ListView_SetTextBkColor(hwnd,0);
	//ListView_SetTextColor(hwnd,0xffff);//GetDC
	listtextcolor =RGB(255,255,255);//GetSysColor(COLOR_WINDOW);//ListView_GetTextBkColor(hwnd);
	listtextbkcolor =RGB(0,0,0);//GetSysColor(COLOR_BACKGROUND);//ListView_GetTextColor(hwnd);
	//paintf =PAINTFLAG_DEF;
}


void sortlist( HWND hList, int num )
{
	num--;
    static int sortsubno[NO_OF_SUBITEM] = {UP};
	if (sortsubno[num] == UP)
		sortsubno[num] = DOWN;
	else
		sortsubno[num] = UP;
	SORTDATA SortData;
	SortData.hwndList = hList;
	SortData.isortSubItem = num;
	SortData.iUPDOWN = sortsubno[num];
	ListView_SortItems(hList, MyCompProc, &SortData);
}


void AddListItem(HWND hList, HANDLE hFind, char *szfname, WIN32_FIND_DATA &wfd, LVITEM &li, int &iItemNo)
{
    SYSTEMTIME localtm;
    FILETIME localft;
    char szBuf[MAX_PATH];
	strcpy(szfname, wfd.cFileName);
    li.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
    li.pszText = szfname;
    li.iItem = iItemNo;
    li.iSubItem = 0;
    li.lParam = iItemNo;
    if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
        li.iImage = DIRECTORY_IMAGE;
    } else {
        li.iImage = FILE_IMAGE;
    }
    ListView_InsertItem(hList, &li);

    li.mask = LVIF_TEXT;
    li.iSubItem = 1;
    if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
        itoa(wfd.nFileSizeLow, li.pszText, 10);
        if (wfd.nFileSizeHigh != 0)
            setstatus("t@CTCY傫܂");
    } else {
        strcpy(li.pszText, isdirectory);
    }
    ListView_SetItem(hList, &li);

    FileTimeToLocalFileTime(&wfd.ftLastWriteTime, &localft);
    FileTimeToSystemTime(&localft, &localtm);
    wsprintf(li.pszText, "%02d/%02d/%02d %02d:%02d",
        localtm.wYear, localtm.wMonth, localtm.wDay, localtm.wHour, localtm.wMinute);
    li.iSubItem = 2;
    ListView_SetItem(hList, &li);

    wsprintf(li.pszText, "%d", wfd.dwFileAttributes);
    li.iSubItem = 3;
    ListView_SetItem(hList, &li);

    GetShortPathName(wfd.cFileName, szBuf, sizeof(szBuf));
    strcpy(li.pszText, szBuf);
    li.iSubItem = 4;
    ListView_SetItem(hList, &li);

    iItemNo++;
}

void InsertMyColumn(HWND hList)
{
    LVCOLUMN lc;

    lc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
    lc.fmt = LVCFMT_LEFT;
    lc.cx = 100;
    lc.pszText = "t@C";
    lc.iSubItem = 0;
    ListView_InsertColumn(hList, 0, &lc);

    lc.fmt = LVCFMT_RIGHT;
    lc.cx = 55;
    lc.pszText = "TCY";
    lc.iSubItem = 1;
    ListView_InsertColumn(hList, 1, &lc);

    lc.fmt = LVCFMT_LEFT;
    lc.cx = 110;
    lc.pszText = "XV";
    lc.iSubItem = 2;
    ListView_InsertColumn(hList, 2, &lc);

    lc.fmt = LVCFMT_RIGHT;
    lc.cx = 30;
    lc.pszText = "";
    lc.iSubItem = 3;
    ListView_InsertColumn(hList, 3, &lc);

    lc.fmt = LVCFMT_LEFT;
    lc.cx = 90;
    lc.pszText = "MS-DOS?";
    lc.iSubItem = 4;
    ListView_InsertColumn(hList, 4, &lc);
    return;
}


