<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters
 */
/**
 * @file ResponseSoapnizer.php
 * @brief ResponseSoapnizer for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ResponseSoapnizer.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * ResponseSoapnizer class
 */

require_once("SOAP/Value.php");
require_once("ficus/parameters/visitors/ParameterAccessor.php");
require_once("ficus/lang/Assert.php");
/**
 * @class Ficus_ResponseSoapnizer
 */
class Ficus_ResponseSoapnizer
{
	/**
	 * convert Accessor to SOAP_Value
	 * @param $accessor Ficus_ParameterAccessor Accessor data
	 * @return array array of PEAR::SOAP_Value
	 */
	public static function convert($accessor){
		Ficus_Assert::typeHinting("Ficus_ParameterAccessor", $accessor);
		$values = self::soapnize($accessor);
		$result = self::normalize($values);
		return $result;
	}

	/**
	 * if value is single element array return SoapValue
	 * @param $values array array of PEAR::SOAP_Value
	 * @return mixed Soap_Value or array of Soap_Value
	 */
	private static function normalize($values){
		if(count($values) == 1){
			reset($values);
			return current($values);
		}
		return $values;
	}

	/**
	 * get flat structure of soap values
	 * @param $accessor Ficus_ParameterAccessor data
	 * @return array array of PEAR::SOAP_Value
	 */
	private static function soapnize($accessor){
		$result = array();
		foreach($accessor as $parameter){
			if($parameter instanceof Ficus_ArrayParameter){
				foreach($parameter as $value){
					if($value instanceof Ficus_ComplexParameter){
						$vacc = new Ficus_ParameterAccessor($value);
						array_push($result, self::soapnize($vacc));
					}else{
						array_push($result, self::soapValue($value));
					}
				}

			}else if($parameter instanceof Ficus_ParameterAccessor){
				$result = array_merge($result, self::soapnize($parameter));
			}else{
				array_push($result, self::soapValue($parameter));
			}
		}
		return $result;
	}

	/**
     * create soap value from parameter
     * @param $parameter Ficus_Parameter parameter to convert
     * @return SOAP_Value converted parameter
     */
	private static function soapValue($parameter){
		return new SOAP_Value($parameter->name(),
							  $parameter->typeName(),
							  $parameter->value());
	}
}
?>
