<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.organizer
 */
/**
 * @file ScaffoldOrganizerFactory.php
 * @brief ScaffoldOrganizerFactory.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldOrganizerFactory.php 17 2007-07-19 13:33:15Z ishitoya $
 *
 */

/**
 * @class Ficus_ScaffoldOrganizerFactory
 */
class Ficus_ScaffoldOrganizerFactory implements Ficus_S2DaoModelConstants{
    const SUFFIX = "ScaffoldPart";
    const PACKAGE = "interface.";

    /**
     * mediator
     */
    protected $mediator = null;
    
    /**
     * constructor
     * @param $mediator Ficus_ScaffoldMediator mediator
     */
    public function __construct($mediator){
        $this->mediator = $mediator;
    }
    
    /**
     * get Organizer
     */
    public function create($context){
        $classname = "Ficus_" . $context . "ScaffoldOrganizer";
        $organizer = new $classname($this->mediator);
        return $organizer;
    }
    
    /**
     * get View Organizer
     * @return Ficus_ViewInterfaceOrganizer view organizer
     */
    public function createViewOrganizer(){
        return $this->create("View");
    }

    /** 
     * create List Organizer
     * @return Ficus_ListInterfaceOrganizer list organizer
     */
    public function createListOrganizer(){
        return $this->create("List");
    }

    /**
     * create Edit Organizer
     * @return Ficus_EditInterfaceOrganizer edit organizer
     */
    public function createEditOrganizer(){
        return $this->create("Edit");
    }

    /**
     * create New Organizer
     * @return Ficus_NewInterfaceOrganizer new organizer
     */
    public function createNewOrganizer(){
        return $this->create("New");
    }

    /**
     * create Hidden Organizer
     * @return Ficus_HiddenInterfaceOrganizer hidden organizer
     */
    public function createHiddenOrganizer(){
        return $this->create("Hidden");
    }
}
?>