<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.container
 */
/**
 * @file ScaffoldPartsContainerList.php
 * @brief ScaffoldPartsContainerList.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldPartsContainerList.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/beans/Bean.php");
require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");

/**
 * @class Ficus_ScaffoldPartsContainerList
 */
class Ficus_ScaffoldPartsContainerList extends Ficus_Bean
implements Ficus_S2DaoModelConstants, Ficus_ScaffoldPartsContainer{
    /**
     * @var container
     */
    protected $organizers = array();

    /**
     * @var parts
     */
    protected $containers = array();

    /**
     * organize
     */
    public function build(){
        $result = "";
        foreach($this->organizers as $organizer){
            $organizer->startVisit($this);
            $this->accept($organizer);
            $organizer->endVisit($this);
            $result .= $organizer->result();
        }
        return $result;
    }
    
    /**
     * organize
     * @param $organizer Ficus_ScaffoldOrganizer organizer
     */
    public function accept($organizer){
        foreach($this->containers as $container){
            $container->addOrganizers($organizer);
            $container->build($organizer);
            $container->clearOrganizers();
        }
    }

    /**
     * returns part
     * @param $name string name to get
     * @return Ficus_ScaffoldPart part
     */
    public function get($index){
        if($this->has($index)){
            return $this->containers[$index];
        }else{
            throw new Ficus_PropertyNotFoundException("property $property is not found");
        }
    }

    /**
     * has
     * @params $property string property name to check
     * @return boolean true if exists
     */
    public function has($index){
        if(array_key_exists($index, $this->containers)){
            return true;
        }
        return parent::has($index);
    }
}
?>
