<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file ScaffoldPages.php
 * @brief abstract buffered page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldPage.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once("ficus/pages/BufferedPage.php");

/**
 * @class Ficus_Page
 */
abstract class Ficus_ScaffoldPage extends Ficus_BufferedPage
implements Ficus_ScaffoldConstants{
    protected $manager = null;
    protected $target = null;
    protected $foreperson = null;
    protected $scaffold = null;
    protected $currentScaffoldAction = null;

    /**
     * on called
     * @param $mode string name of mode
     * @param $args array of args of do method
     */
    protected function onDo($mode, $args){
        if(($action = $this->isScaffoldAction($mode))){
            $this->scaffold = null;
            Ficus_PageComponentFactory::getSmarty()->addPath(self::SMARTY_SCAFFOLD, Ficus_Dir::normalize(Ficus_File::currentDir() . "/templates"));
            if(empty($this->target)){
                if($this->request->has(self::KEY_TARGET)){
                    $this->target =
                        $this->request->extractAsString(self::KEY_TARGET);
                }else{
                    throw new Ficus_NotReadyException("scaffold action needs target table, set " . self::KEY_TARGET . "parameter or set target property.");
                }
            }
            $this->foreperson = strtolower($action);
            $action = $this->getScaffoldAction($action);
            $this->setNextAction($action);
            $this->manager = new Ficus_ScaffoldManager($this);
            $this->currentScaffoldAction = $this->manager->formBean()->do();
        }
    }

    /**
     * exec scaffold
     */
    protected function buildScaffold(){
        $this->scaffold = $this->manager->organize();
        $this->assign(self::SMARTY_SCAFFOLD, $this->scaffold);
    }

    /**
     * on execute finished
     * @param $mode string name of mode
     * @param $args array of args of do method
     * @param $result mixed switch
     */
    protected function onDone($mode, $args, $result){
        if($this->isScaffoldAction($mode) &&
           $result == self::MODE_TEMPLATE){
            $this->buildScaffold();

            $mode = $this->foreperson;
            $template = $this->getModeTemplate($mode);

            $result = $this->dispatchScaffoldEvent("done", $args);
            if(is_null($result)){
                $result = $template;
            }

            if(Ficus_PageComponentFactory::getSmarty()
               ->isTemplateExists($result)){
                return parent::onDone($mode, $args, $result);
            }else{
                return parent::onDone($mode, $args,
                                      self::DEFAULT_SCAFFOLD_TEMPLATE);
            }
        }
        return parent::onDone($mode, $args, $result);
    }

    /**
     * scaffold
     */
    protected function execScaffoldAction($args){
        $result = $this->dispatchScaffoldEvent("do", $args);
        if(is_null($result)){
            return self::MODE_TEMPLATE;
        }
        return $result;
    }

    /**
     * do new
     */
    public function __call($name, $args){
        if($this->methodExists($name) &&
           preg_match('/^doScaffold.*$/', $name)){
            return $this->execScaffoldAction($args);
        }
        return parent::__call($name, $args);
    }

    /**
     * check for method existance
     */
    protected function methodExists($method){
        if(preg_match('/^doScaffold(.*)$/', $method, $regs)){
            $action = strtolower($regs[1]);
            if($action == self::ACTION_NEW  || $action == self::ACTION_EDIT ||
               $action == self::ACTION_LIST || $action == self::ACTION_VIEW ||
               $action == self::ACTION_DELETE){
                return true;
            }
        }
        return parent::methodExists($method);
    }

    /**
     * get modes
     */
    public function getModes(){
        $modes = parent::getModes();
        $modes[] = $this->getScaffoldAction(self::ACTION_NEW);
        $modes[] = $this->getScaffoldAction(self::ACTION_EDIT);
        $modes[] = $this->getScaffoldAction(self::ACTION_DELETE);
        $modes[] = $this->getScaffoldAction(self::ACTION_VIEW);
        $modes[] = $this->getScaffoldAction(self::ACTION_LIST);
        return $modes;
    }

    /**
     * get action
     */
    protected function getScaffoldAction($action){
        return self::ACTION_PREFIX . ucfirst($action);
    }

    /**
     * is scaffold action
     */
    protected function isScaffoldAction($mode){
        if(preg_match('/^' . self::ACTION_PREFIX . '(.*)$/', $mode, $regs)){
            return $regs[1];
        }
        return false;
    }

    /**
     * call event handler
     */
    protected function dispatchScaffoldEvent($context, $args){
        $prefix = "on" . ucfirst($context) . "Scaffold";
        $methodDefault = $prefix. ucfirst($this->foreperson);
        $method = $methodDefault . ucfirst($this->currentScaffoldAction);
        if(method_exists($this, $method)){
            return $this->{$method}($args);
        }

        $pair =
            Ficus_PageComponentFactory::getPageController()->chain()->prev();
        if(is_null($pair) == false){
            $action = $pair->action();
            $method = "on" . ucfirst($context) . ucfirst($action) . "Scaffold" . ucfirst($this->foreperson) . ucfirst($this->currentScaffoldAction);
            if(method_exists($this, $method)){
                return $this->{$method}($args);
            }
        }

        $method = "on" . ucfirst($context) . ucfirst($this->target) . "Scaffold" . ucfirst($this->foreperson) . ucfirst($this->currentScaffoldAction);
        if(method_exists($this, $method)){
            return $this->{$method}($args);
        }
        if(method_exists($this, $methodDefault)){
            return $this->{$methodDefault}($args);
        }
        
        return null;
    }
}
?>
