<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageModeExtractor.php
 * @brief controll page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageModeExtractor.php 7 2007-07-14 10:55:18Z ishitoya $
 */
require_once("ficus/lang/ClassLoader.php");

/**
 * @class Ficus_PageModeExtractor
 */
class Ficus_PageModeExtractor{
    /**
     * modes
     */
    private $modes = array();

    /**
     * default mode
     */
    private $defaultMode = null;

    /**
     * construct with modes
     * @param $modes Ficus_Page of modes
     */
    public function __construct($page){
        $modes = $this->extractModes($page);
        foreach($modes as $mode){
            $this->addMode($mode);
        }
    }

    /**
     * add mode
     * @param $mode string name of mode
     */
    public function addMode($mode){
        $this->modes[trim($mode)] = trim($mode);
    }

    /**
     * set default mode
     * @param $defaultMode string default mode name
     */
    public function setDefaultMode($defaultMode){
        $this->defaultMode = $defaultMode;
    }
    
    /**
     * get mode
     * @return string mode
     */
    public function getMode(){
        if(empty($_REQUEST)){
            return $this->defaultMode;
        }else{
            $keys = array_keys($_REQUEST);
            foreach($keys as $key){
                if(preg_match('/^(.*)_([^_]+)$/', $key, $matches)){
                    $prefix = $matches[1];
                    if(array_key_exists($prefix, $this->modes)){
                        return $this->modes[$prefix];
                    }
                }
                if(array_key_exists($key, $this->modes)){
                    return $this->modes[$key];
                }
            }
        }
        return $this->defaultMode;
    }

    /**
     * extract mode from $_REQUEST
     * @param $page Ficus_Page target page
     * @return array array of modes
     */
    private function extractModes($page){
        $modes = array();
        return $page->getModes();
    }
}
?>