<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file URIComponentFactory.php
 * @brief URI component factory
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URIFactoryComponentFactory.php 12 2007-07-15 14:41:51Z ishitoya $
 * 
 * URI component factory
 */

require_once("ficus/io/File.php");
require_once("ficus/config/Registry.php");
require_once("ficus/lang/AutoLoad.php");
require_once("ficus/lang/S2ContainerAutoLoad.php");
require_once("ficus/lang/ClassLoaderAutoLoad.php");
require_once("ficus/net/URLFactoryImpl.php");

/**
 * @class Ficus_URIComponentFactory
 */
class Ficus_URIFactoryComponentFactory {

    /**
     * Default dicon file name.
     */
    const DEFAULT_DICON_FILE = 'uri.dicon';

    /**
     * URI dicon path.
     */
    const DICON_PATH = 'FICUS_URI_DICON_PATH';

    /**
     * URI extend dicon path.
     */
    const EXTEND_DICON_PATH = 'FICUS_URI_EXTEND_DICON_PATH';

    /**
     * dicon namespace.
     */
    const DICON_NAMESPACE = 'uri.scheme';

    /**
     * @var S2Container S2Container.
     */
    private static $container = null;

    /**
     * Get dicon path.
     *
     * return string dicon path..
     */
    private static function getDiconPath() {
        if (!defined(self::DICON_PATH)) {
            define(self::DICON_PATH,
                   preg_replace('/\\\/', '/', dirname(__FILE__)));
        }

        $diconPath = Ficus_Registry::search(self::EXTEND_DICON_PATH);
        if ($diconPath === false || !is_readable($diconPath)) {
            $diconPath = Ficus_File::currentDir()
                                ->resolve(self::DEFAULT_DICON_FILE)->getPath();
        }
        return $diconPath;
    }

    /**
     * Get S2Container.
     *
     * return S2Container S2Container.
     */
    private static function getS2Container() {
        if (self::$container == null) {
            $diconPath = self::getDiconPath();
            self::$container = S2ContainerFactory::create($diconPath);
            Ficus_AutoLoad::add(new Ficus_S2ContainerAutoLoad());
        }
        return self::$container;
    }

    /**
     * Get URI builder component.
     *
     * @param $scheme string scheme.
     * @return Ficus_URIBuilder URI component.
     */
    public static function getBuilderComponent($scheme) {
        $container = self::getS2Container();
        $componentName = self::DICON_NAMESPACE  . '.' . strtolower($scheme);
        return $container->getComponent($componentName);
    }

}
?>
