<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file Object.php
 * @brief Object for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Object.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Object
 */
require_once('ficus/exception/MethodNotFoundException.php');
require_once('ficus/exception/PropertyNotFoundException.php');
/**
 * @class Ficus_Object
 */
class Ficus_Object {

    /**
     * Get property by name.
     *
     * @param $name string property name.
     * @return mixed property value.
     * @throw Ficus_PropertyNotFoundException property not found.
     */
    public function __get($name) {
        if ($name == 'scalar') {
            return $this->toString();
        }
        throw new Ficus_PropertyNotFoundException('Call to undefined method ' . get_class($this) . "::$name");
    }

    /**
     * Call method by name.
     *
     * @param $name string method name.
     * @param $arguments array arguments of method.
     * @return mixed return value of method.
     * @throw Ficus_MethodNotFoundException method not found.
     */
    public function __call($name, $arguments) {
        if (method_exists($this, $name)) {
            call_user_func_array(array($this, $name), $arguments);
        } else {
            throw new Ficus_MethodNotFoundException('Call to undefined method ' . get_class($this) . "::$name()");
        }
    }

    /**
     * To string.
     *
     * @return string to string of this object.
     */
    public function __toString() {
        if (method_exists($this, 'toString')) {
            return $this->toString();
        } else {
            return '';
        }
    }

}
?>
