<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file AstorogyDates.php
 * @brief astorogy date
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AstorogyDate.php 2 2007-07-11 10:37:48Z ishitoya $
 */

/**
 * @class Ficus_AstorogyDate
 */
class Ficus_AstorogyDate{
    const MODE_TWELFTH = "12";
    const MODE_THIRTEENTH = "13";

    const ARIES = 0;
    const TAURUS = 1;
    const GEMINI = 2;
    const CANCER = 3;
    const LEO = 4;
    const VIRGO = 5;
    const LIBRA = 6;
    const SCROPIO = 7;
    const SAGITTARIUS = 8;
    const CAPRICORN = 9;
    const AQUERIUS = 10;
    const PISCES = 11;
    const OPHIUCHUS = 12;
    
    public static function examin($month, $day, $mode = self::MODE_TWELFTH){
        if($mode == self::MODE_TWELFTH){
            if(($month == 3 && $day >= 21) ||
               ($month == 4 && $day <= 19)){
                return self::ARIES;
            }else if(($month == 4 && $day >= 20) ||
                     ($month == 5 && $day <= 20)){
                return self::TAURUS;
            }else if(($month == 5 && $day >= 21) ||
                     ($month == 6 && $day <= 21)){
                return self::GEMINI;
            }else if(($month == 6 && $day >= 22) ||
                     ($month == 7 && $day <= 22)){
                return self::CANCER;
            }else if(($month == 7 && $day >= 23) ||
                     ($month == 8 && $day <= 22)){
                return self::LEO;
            }else if(($month == 8 && $day >= 23) ||
                     ($month == 9 && $day <= 22)){
                return self::VIRGO;
            }else if(($month == 9 && $day >= 23) ||
                     ($month == 10 && $day <= 23)){
                return self::LIBRA;
            }else if(($month == 10 && $day >= 24) ||
                     ($month == 11 && $day <= 22)){
                return self::SCROPIO;
            }else if(($month == 11 && $day >= 23) ||
                     ($month == 12 && $day <= 22)){
                return self::SAGITTARIUS;
            }else if(($month == 12 && $day >= 23) ||
                     ($month == 1 && $day <= 19)){
                return self::CAPRICORN;
            }else if(($month == 1 && $day >= 20) ||
                     ($month == 2 && $day <= 18)){
                return self::AQUERIUS;
            }else if(($month == 2 && $day >= 19) ||
                     ($month == 3 && $day <= 20)){
                return self::PISCES;
            }
        }else{
            if(($month == 3 && $day >= 19) ||
               ($month == 4 && $day <= 13)){
                return self::ARIES;
            }else if(($month == 4 && $day >= 14) ||
                     ($month == 5 && $day <= 20)){
                return self::TAURUS;
            }else if(($month == 5 && $day >= 21) ||
                     ($month == 6 && $day <= 19)){
                return self::GEMINI;
            }else if(($month == 6 && $day >= 22) ||
                     ($month == 7 && $day <= 10)){
                return self::CANCER;
            }else if(($month == 7 && $day >= 11) ||
                     ($month == 8 && $day <= 15)){
                return self::LEO;
            }else if(($month == 8 && $day >= 16) ||
                     ($month == 9 && $day <= 29)){
                return self::VIRGO;
            }else if(($month == 9 && $day >= 30) ||
                     ($month == 10 && $day <= 22)){
                return self::LIBRA;
            }else if(($month == 10 && $day >= 23) ||
                     ($month == 11 && $day <= 29)){
                return self::SCROPIO;
            }else if(($month == 11 && $day >= 30) ||
                     ($month == 12 && $day <= 17)){
                return self::OPHIUCHUS - 5;
            }else if(($month == 12 && $day >= 18) ||
                     ($month == 1 && $day <= 18)){
                return self::SAGITTARIUS + 1;
            }else if(($month == 1 && $day >= 19) ||
                     ($month == 2 && $day <= 15)){
                return self::CAPRICORN + 1;
            }else if(($month == 2 && $day >= 16) ||
                     ($month == 3 && $day <= 10)){
                return self::AQUERIUS + 1;
            }else if(($month == 3 && $day >= 11) ||
                     ($month == 4 && $day <= 18)){
                return self::PISCES + 1;
            }
        }
    }        
}
?>
