<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.models
 */
/**
 * @file DataTransferObject.php
 * @brief DataTransferObject.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: S2DaoDataTransferObject.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/db/s2dao/models/S2DaoEntity.php");

/**
 * @class Ficus_S2DaoDataTransferObject
 */
class Ficus_S2DaoDataTransferObject extends Ficus_S2DaoEntity implements S2Dao_PagerCondition{
    private $offset = 0;
    private $limit = null;
    private $count = 0;
    
    /**
     * @return Returns the total.
     */
    public function getCount() 
    {
        return $this->count;
    }

    /**
     * @param total The total to set.
     */
    public function setCount($total) 
    {
        $this->count = $total;
    }

    /**
     * @return Returns the limit.
     */
    public function getLimit() 
    {
        return $this->limit;
    }

    /**
     * @param limit The limit to set.
     */
    public function setLimit($limit) 
    {
        $this->limit = $limit;
    }

    /**
     * @return Returns the offset.
     */
    public function getOffset() 
    {
        return $this->offset;
    }
    
    /**
     * @param offset The offset to set.
     */
    public function setOffset($offset) 
    {
        $this->offset = $offset;
    }

    /**
	 * get related DAO object
	 * @return Ficus_Auto<{$classname}>Dao dao object
	 */
    public function dao(){
        return Ficus_ComponentFactory::getComponent("Auto<{$classname}>Dao");
	}
}
?>
