<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.collection
 */
/**
 * @file TypedMap.php
 * @brief This class is implementation of interface Map.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: TypedMap.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/lang/ClassLoader.php");
require_once("ficus/lang/Assert.php");
require_once("ficus/collection/SimpleMap.php");
require_once("ficus/exception/ClassNotFoundException.php");
require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/exception/TypeMismatchException.php");

/**
 * @class Ficus_TypedMap
 */
class Ficus_TypedMap extends Ficus_SimpleMap{

    /**
     * @var $elements array elements
     */
    protected $elements = array();

    /**
     * @var $type string Type
     */
    protected $type = null;

    /**
     * constructor
     * @param $type String Type to check
     * @param $keys Array key array of elements
     * @param $elements Array elements to add this map
     * @throw Ficus_IllegalArgumentException illegal argument.
     */
    public function __construct($type, $keys = array(), $elements = array()){
        if(class_exists($type) == false && interface_exists($type) == false){
            try{
                Ficus_ClassLoader::import($type);
            }catch(Ficus_ClassNotFoundException $e){
                throw new Ficus_IllegalArgumentException("passed type is not valid type $type");
            }
        }

        $this->type = $type;
        parent::__construct($keys, $elements);
    }
    
    /**
     * add element to Collection
     * @param $key key of element to add
     * @param $element Element to add the Map
     * @return value returns old value if the key found in Map
     * @throw Ficus_IllegalArgumentException illegal argument.
     */
    public function put($key, $element){
        try{
            Ficus_Assert::isInstanceOf($element, $this->type);
        }catch(Ficus_TypeMismatchException $e){
            throw new Ficus_IllegalArgumentException("passed element is not instance of {$this->type}, it is" . get_class($element) . ".");
        }
        return parent::put($key, $element);
    }

    /**
     * return type of this Map
     * @return string type of this Map
     */
    public function type(){
        return $this->type;
    }
}
