<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file LiteralType.php
 * @brief LiteralType.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: LiteralType.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
/**
 * @class Ficus_LiteralType
 */
interface Ficus_LiteralType
{
    /**
     * XML schema namespace.
     */
    const NS_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema#";

    /**
     * RDF schema namespace.
     */
    const NS_RDF_SCHEMA = "http://www.w3.org/2000/01/rdf-schema#";

    /**
     * Plain literal.
     */
    const PLAIN_LITERAL = true;

    /**
     * Typed literal.
     */
    const TYPED_LITERAL = false;

    /**
     * Type.
     *
     * @return string of literal type.
     */
    public function type();

    /**
     * Lang.
     *
     * @return string of literal lang.
     */
    public function lang();

    /**
     * Is plain literal.
     *
     * @return boolean true if plain literal.
     */
    public function is_plain();

    /**
     * Is typed literal.
     *
     * @return boolean true if typed literal.
     */
    public function is_typed();

    /**
     * Literal and literal type separator.
     */
    public function separator();

    /**
     * To string.
     *
     * @return string of literal.
     */
    public function toString();

    /**
     * To string.
     *
     * @return string of literal.
     */
    public function __toString();

    /**
     * To string of prefixed QName.
     *
     * @param $xsd string XML schema namespace prefix.
     * @param $rdfs string RDF schema namespace prefix.
     * @return string string of literal.
     */
    public function toPrefixedQName($xsd = "xsd", $rdfs = "rdfs");
}
?>
