<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file Graph.php
 * @brief Graph.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Graph.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once("ficus/RDF/AnyNode.php");
require_once("ficus/RDF/Node.php");
require_once("ficus/RDF/BlankNode.php");
require_once("ficus/RDF/Quad.php");
require_once("ficus/lang/Arrays.php");
require_once("ficus/lang/Assert.php");
/**
 * @class Ficus_Graph
 */
interface Ficus_Graph extends IteratorAggregate
{
    /**
     * add.
     *
     * @param $name Ficus_Node name.
     * @param $subject Ficus_Node subject.
     * @param $predicate Ficus_Node predicate.
     * @param $object Ficus_Node object.
     */
    public function add($name, $subject, $predicate, $object);

    /**
     * add quad.
     *
     * @param $quad Ficus_Quad of quad.
     * @return boolean true if added; false if quad already exist.
     */
    public function addQuad($quad);

    /**
     * add graph.
     *
     * @param $graph Ficus_Graph of graph.
     */
    public function addGraph($graph);

    /**
     * remove quad.
     *
     * @param $quad Ficus_Quad Ficus_Quad of quad.
     */
    public function removeQuad($quad);

    /**
     * contains quads.
     *
     * @param $quad Ficus_Quad
     * @return boolean true if contains quad.
     */
    public function contains($quad);

    /**
     * find triple in this graph.
     *
     * @param $name Ficus_Node name.
     * @param $subject Ficus_Node subject.
     * @param $predicate Ficus_Node predicate.
     * @param $object Ficus_Node object.
     * @return Ficus_Graph found graph.
     */
    public function find($name, $subject, $predicate, $object);

    /**
     * set namespaces.
     *
     * @param $namespaces array array of namespace
     */
    public function setNamespaces($namespaces);

    /**
     * namespaces.
     *
     * @return array of $namespace.
     */
    public function namespaces();

    /**
     * count graph.
     *
     * @return int count of graph.
     */
    public function count();

    /**
     * Equals to another graph.
     *
     * @param $graph Ficus_Graph graph.
     */
    public function equals($graph);
}
?>
