<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.test
 */
/**
 * @file Arrays.php
 * @brief Arrays for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: DbUnitTestCase.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * DbUnit Testcase.
 */
require_once "PHPUnit/Framework/TestCase.php";
require_once "lib/adodb/adodb.inc.php";
/**
 * @class Ficus_DbUnitTestCase
 */
abstract class Ficus_DbUnitTestCase extends PHPUnit_Framework_TestCase
{

    /**
     * ADO DB connector.
     */
    private $connector;

    /**
     * Setup Testcase
     *
     * @throw Exception setup error.
     */
    public function setUp() {
        $dbini = Ficus_PropertyFileReader::read($this->getDbPropertyName());
        $this->connector = &ADONewConnection($dbini['dbtype']);
        $this->connector->PConnect($dbini['host'], $dbini['user'], $dbini['password'], $dbini['dbname']);
        //$this->connector->debug = true;

        if ($this->getDeleteSQL() != '') {
            $deleteSQL = file_get_contents($this->getDeleteSQL());
            if ($deleteSQL === false) {
                throw new Exception("Delete SQL file not found." . $this->getDeleteSQL());
            }
            if (($ret = $this->connector->Execute($deleteSQL)) === false) {
                throw new Exception("Database error!! " . $this->connector->ErrorMsg());
            }
        }
        if ($this->getInitSQL() != '') {
            $initSQL = file_get_contents($this->getInitSQL());
            if ($initSQL === false) {
                throw new Exception("Init SQL file not found." . $this->getInitSQL());
            }
            if (($ret = $this->connector->Execute($initSQL)) === false) {
                throw new Exception("Database error!! " . $this->connector->ErrorMsg());
            }
        }

    }

    /**
     * Clean up Testcase
     *
     * @throw Exception setup error.
     */
    public function tearDown() {
        if (($ret = $this->connector->Execute(file_get_contents($this->getDeleteSQL()))) === false) {
            throw new Exception("Database error!! " . $this->connector->ErrorMsg());
        }
        $this->connector->Close();
    }

    /**
     * Get connector.
     */
    public function getConnector() {
         return $this->connector;
    }

    /**
     * Execute SQL.
     *
     * @param $sql string SQL.
     * @throw Exception setup error.
     */
    public function executeQuery($sql) {
        if (($ret = $this->connector->Execute($sql)) === false) {
            throw new Exception("database error!! " . $this->connector->ErrorMsg());
        }
        return $ret->GetArray();
    }

    /**
     *
     */
    abstract public function getDeleteSQL();

    /**
     *
     */
    abstract public function getInitSQL();

    /**
     *
     */
    abstract public function getDbPropertyName();
}
?>
