<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.organizer
 */
/**
 * @file ListScaffoldOrganizer.php
 * @brief ListScaffoldOrganizer.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ListScaffoldOrganizer.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/lang/Assert.php");
require_once("scaffold/ScaffoldOrganizer.php");

/**
 * @class Ficus_ListScaffoldOrganizer
 */
class Ficus_ListScaffoldOrganizer
extends Ficus_AbstractScaffoldOrganizer{
    const TEMPLATE_PREFIX = "list/";

    protected $rowTemplate = "";
    protected $headerTemplate = "";
    protected $header = "";
    protected $rows = array();

    /**
     * prefix
     * @return string template prefix
     */
    public function prefix(){
        return parent::prefix() . self::TEMPLATE_PREFIX;
    }

    /**
     * on visit
     * @param $part Ficus_ScaffoldPart part
     */
    protected function onVisit($part){
        $entityName = $part->entity()->getEntityName();
        if($part->type() == self::TYPE_DIRECT){
            return;
        }
        if($this->mediator->isExcludeProperty($part)){
            return;
        }
        
        $value = null;
        if($part->value() instanceof Ficus_S2DaoEntity){
            if($part->type() == self::TYPE_LIST){
                $key = $part->value()->name();
                if(is_null($key)){
                    $value = "";
                }else{
                    $value = $part->value()->names($part->value()->name());
                }
            }else if($template =
                     Ficus_ScaffoldTemplateParser::getTemplate($part)){
                $value =
                    Ficus_ScaffoldTemplateParser::parse($template, $part);
            }else{
                $value = $this->getChildren($part);
            }
        }else{
            $value = $part->value();
        }
        $this->assign("part", $part);
        $this->assign("value", $value);
        $result = $this->fetch($this->itemTemplate);
        $this->addResult($result);
    }

    /**
     * start visit
     * @param $container Ficus_ScaffoldPartsContainer
     */
    public function startVisit($container){
        if($container instanceof Ficus_ScaffoldPartsContainerList){
            if($container->isEmptyContainers()){
                return;
            }
            $container = $container->get(0);
            $parts = $container->parts();
            $this->assign("delete", "delete");
            $this->header = $this->createHeader($parts);
            $this->clear("delete");
        }
    }

    /**
     * end visit
     * @param $container Ficus_ScaffoldPartsContainer
     */
    public function endVisit($container){
        if($container instanceof Ficus_ConcreteScaffoldPartsContainer){
            $this->assign("entity", $container->entity());
            $this->assign("result", $this->result);
            $result = $this->fetch($this->rowTemplate);
            $this->rows[] = $result;
            $this->result = "";
        }else if($container instanceof Ficus_ScaffoldPartsContainerList){
            $this->assign("header", $this->header);
            $this->assign("rows", $this->rows);
            $this->display($this->entityTemplate);
        }
    }

    /**
     * create header
     * @param $parts array of interface part
     * @return string header
     */
    protected function createHeader($parts){
        $labels = array();
        foreach($parts as $part){
            if($this->mediator->isExcludeProperty($part)){
                continue;
            }
            if($part->type() == self::TYPE_DIRECT){
                continue;
            }
            $labels[] = $part->label();
        }
        $this->assign("labels", $labels);
        return $this->fetch($this->headerTemplate);
    }

    /**
     * get child
     */
    protected function getChildren($part){
        $input = "";
        foreach($part->parts() as $child){
            $result = $this->result;
            $this->result = "";
            $child->accept($this);
            $input .= $this->result;
            $this->result = $result;
            $this->assign("nolabel", false);
        }
        $this->clear("entity");
        $this->assign("result", $input);
        $row = $this->fetch($this->rowTemplate);
        $rows = array();
        $rows[] = $row;
        $this->assign("header", $this->createHeader($part->parts()));
        $this->assign("rows", $rows);
        return $this->fetch($this->entityTemplate);
    }

    /*
     * set header template
     * @param $headerTemplate string template file name
     */
    public function setHeaderTemplate($headerTemplate){
        $this->headerTemplate = $headerTemplate;
    }

    /*
     * set row template
     * @param $headerTemplate string template file name
     */
    public function setRowTemplate($rowTemplate){
        $this->rowTemplate = $rowTemplate;
    }
}
?>