<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.container
 */
/**
 * @file ConcreteScaffoldPartsContainer.php
 * @brief ConcreteScaffoldPartsContainer.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ConcreteScaffoldPartsContainer.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/beans/Bean.php");
require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");

/**
 * @class Ficus_ConcreteScaffoldPartsContainer
 */
class Ficus_ConcreteScaffoldPartsContainer extends Ficus_Bean
implements Ficus_S2DaoModelConstants, Ficus_ScaffoldPartsContainer{
    /**
     * entity
     */
    protected $entity = null;
    
    /**
     * @var organizers
     */
    protected $organizers = array();

    /**
     * @var parts
     */
    protected $parts = array();

    /**
     * constructor
     */
    public function __construct($entity){
        $this->entity = $entity;
    }
    
    /**
     * organize
     */
    public function build(){
        $result = "";
        foreach($this->organizers as $organizer){
            $organizer->startVisit($this);
            $this->accept($organizer);
            $organizer->endVisit($this);
            $result .= $organizer->result();
        }
        return $result;
    }
    
    /**
     * organize
     * @param $organizer Ficus_ScaffoldOrganizer organizer
     */
    public function accept($organizer){
        foreach($this->parts as $part){
            $organizer->visit($part);
        }
    }

    /**
     * returns part
     * @param $property string name to get
     * @return Ficus_ScaffoldPart part
     */
    public function get($property){
        if($this->has($property)){
            return $this->parts[$property];
        }else{
            throw new Ficus_PropertyNotFoundException("property $property is not found");
        }
    }

    /**
     * has
     * @params $property string property name to check
     * @return boolean true if exists
     */
    public function has($property){
        if(array_key_exists($property, $this->parts)){
            return true;
        }
        return parent::has($property);
    }
     
    
    const METHOD_SIGNATURE = '/^(get|has)(.*?)$/';
    /**
     * get property
     * @param $name string method name
     * @param $arguments array of arguments
     */
    public function __call($name, $arguments){
        if(preg_match(self::METHOD_SIGNATURE, $name, $regs)){
            $property = trim($regs[2]);
            if(empty($regs[1]) == false){
                $operation = trim($regs[1]);
            }

            if($operation == "get"){
                return $this->get($property);
            }else if($operation == "has"){
                return $this->has($property);
            }
        }
        
        return parent::__call($name, $arguments);
    }
}
?>
