<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.container
 */
/**
 * @file AbstractScaffoldPart.php
 * @brief AbstractScaffoldPart.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldPart.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/beans/Bean.php");
require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");

/**
 * @class Ficus_AbstractScaffoldPart
 */
abstract class Ficus_AbstractScaffoldPart extends Ficus_Bean
implements Ficus_S2DaoModelConstants, Ficus_ScaffoldPart{
    const TEMPLATE_PREFIX = "common/scaffold/";
    const TEMPLATE_EXTENSION = ".tpl";
    
    protected $name;
    protected $type;
    protected $value;
    protected $label;
    protected $remark;
    protected $template = null;
    protected $parts = array();

    protected static $smarty = null;

    protected function prefix(){
        return self::TEMPLATE_PREFIX;
    }
    
    protected function template(){
        if(is_null($this->template)){
            $classname = get_class($this);
            $tempalte = substr($classname, strpos($classname, _));
            return $this->prefix() . $template . self::TEMPLATE_EXTENSION;
        }else{
            return $this->prefix() . $this->template .
                self::TEMPLATE_EXTENSION;
        }
    }
    
    public function onBuild(){
        if(is_null(self::$smarty)){
            self::$smarty = Ficus_PageComponentFactory::getSmarty();
        }
        
        self::$smarty->assign("part", $this);
    }
    
    public function fetch(){
        $this->onDisplay();
        return self::$smarty->fetch($this->template());
    }

    public function display(){
        $this->onDisplay();
        self::$smarty->display($this->template());
    }

    public function isComposite(){
        if(empty($this->parts)){
            return false;
        }
        return true;
    }
}
?>
