<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.builder
 */
/**
 * @file AbstractScaffoldBuilder.php
 * @brief AbstractScaffoldBuilder.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ConcreteScaffoldBuilder.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/lang/Assert.php");

/**
 * @class Ficus_AbstractScaffoldBuilder
 */
class Ficus_ConcreteScaffoldBuilder
implements Ficus_ScaffoldBuilder{
    /**
     * build interface from entity
     * @param $entity Ficus_S2DaoEntity entity
     */
    public function build($entity){
        if($entity instanceof S2Dao_ArrayList){
            $list = new Ficus_ScaffoldPartsContainerList();
            foreach($entity as $target){
                $list->addContainers($this->createContainer($target));
            }
            return $list;
        }else{
            return $this->createContainer($entity);
        }
    }

    /**
     * create container
     * @param $parts array of parts
     * @return Ficus_ConcreateScaffoldPartsContainer
     */
    protected function createContainer($entity){
        Ficus_Assert::isInstanceOf($entity, "Ficus_S2DaoEntity");
        $parts = $this->buildParts($entity);
        $container = new Ficus_ConcreteScaffoldPartsContainer($entity);
        $container->setParts($parts);
        return $container;
    }
    
    /**
     * build parts array
     * @param $entity Ficus_S2DaoEntity target entity
     * @return array of parts
     */
    protected function buildParts($entity){
        $reader = new Ficus_S2DaoEntityAnnotationReader($entity);

        $settings = Ficus_Registry::search("tableSettings");
        if(isset($settings[$entity->getEntityName()])){
            $setting = $settings[$entity->getEntityName()];
            if(isset($setting["parent"])){
                $setting = $settings[$setting["parent"]];
            }
            $reader->sort($setting);
        }
           
        $parts = array();
        $properties = $reader->properties();
        foreach($properties as $property){
            $value = $entity->get($property);
            $part = $this->buildPart($reader, $property, $value);
            $parts[$property] = $part;
        }
        return $parts;
    }


    /**
     * build part
     * @param $reader Ficus_S2DaoEntityAnnotationReader reader
     * @param $property string property name
     * @param $value mixed value
     * @return Ficus_ScaffoldPart part
     */
    protected function buildPart($reader, $property, $value){
        $type = $reader->type($property);
        $label = $reader->label($property);
        $remark = $reader->remark($property);
        $datatype = $reader->datatype($property);

        $part = Ficus_ScaffoldPartsFactory::create(
                                  $property, $type, $datatype);
        $part->setEntity($reader->getTarget());
        $part->setName($property);
        $part->setType($type);
        $part->setLabel($label);
        $part->setRemark($remark);

        if($value instanceof Ficus_S2DaoEntity){
            $parts = $this->buildParts($value);
            foreach($parts as $child){
                $child->setParent($part);
            }
            $part->setParts($parts);
        }
        $part->setValue($value);
        return $part;
    }
}
?>